/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import com.google.common.base.Predicates;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.recipe.ITerraPlateRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

import javax.annotation.Nullable;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3000;
import net.minecraft.class_3419;
import net.minecraft.class_3528;
import java.util.ArrayList;
import java.util.List;

public class TileTerraPlate extends TileMod implements ISparkAttachable, class_3000 {
	public static final class_3528<IMultiblock> MULTIBLOCK = new class_3528<>(() -> PatchouliAPI.get().makeMultiblock(
			new String[][] {
					{
							"___",
							"_P_",
							"___"
					},
					{
							"RLR",
							"L0L",
							"RLR"
					}
			},
			'P', ModBlocks.terraPlate,
			'R', "#botania:terra_plate_base",
			'0', "#botania:terra_plate_base",
			'L', "#c:lapis_blocks"
	));

	private static final String TAG_MANA = "mana";

	private int mana;

	public TileTerraPlate() {
		super(ModTiles.TERRA_PLATE);
	}

	@Override
	public void method_16896() {
		if (field_11863.field_9236) {
			return;
		}

		boolean removeMana = true;

		if (hasValidPlatform()) {
			List<class_1799> items = getItems();
			class_1277 inv = new class_1277(items.toArray(new class_1799[0]));

			ITerraPlateRecipe recipe = getCurrentRecipe(inv);
			if (recipe != null) {
				removeMana = false;
				ISparkEntity spark = getAttachedSpark();
				if (spark != null) {
					SparkHelper.getSparksAround(field_11863, field_11867.method_10263() + 0.5, field_11867.method_10264() + 0.5, field_11867.method_10260() + 0.5, spark.getNetwork())
							.filter(otherSpark -> spark != otherSpark && otherSpark.getAttachedTile() instanceof IManaPool)
							.forEach(os -> os.registerTransfer(spark));
				}
				if (mana > 0) {
					VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
					int proportion = Float.floatToIntBits(getCompletion());
					PacketBotaniaEffect.sendNearby(field_11863, method_11016(),
							PacketBotaniaEffect.EffectType.TERRA_PLATE, method_11016().method_10263(), method_11016().method_10264(), method_11016().method_10260(), proportion);
				}

				if (mana >= recipe.getMana()) {
					for (class_1799 item : items) {
						item.method_7934(1);
					}
					class_1542 item = new class_1542(field_11863, method_11016().method_10263() + 0.5, method_11016().method_10264() + 0.2, method_11016().method_10260() + 0.5, recipe.method_8116(inv));
					item.method_18799(class_243.field_1353);
					field_11863.method_8649(item);
					field_11863.method_8465(null, item.method_23317(), item.method_23318(), item.method_23321(), ModSounds.terrasteelCraft, class_3419.field_15245, 1, 1);
					mana = 0;
					field_11863.method_8455(field_11867, method_11010().method_26204());
					VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
				}
			}
		}

		if (removeMana) {
			receiveMana(-1000);
		}
	}

	private List<class_1799> getItems() {
		List<class_1542> itemEntities = field_11863.method_8390(class_1542.class, new class_238(field_11867, field_11867.method_10069(1, 1, 1)), class_1301.field_6154);
		List<class_1799> stacks = new ArrayList<>();
		for (class_1542 entity : itemEntities) {
			if (!entity.method_6983().method_7960()) {
				stacks.add(entity.method_6983());
			}
		}
		return stacks;
	}

	private class_1277 getInventory() {
		List<class_1799> items = getItems();
		return new class_1277(items.toArray(new class_1799[0]));
	}

	@Nullable
	private ITerraPlateRecipe getCurrentRecipe(class_1277 items) {
		return field_11863.method_8433().method_8132(ModRecipeTypes.TERRA_PLATE_TYPE, items, field_11863).orElse(null);
	}

	private boolean isActive() {
		return getCurrentRecipe(getInventory()) != null;
	}

	private boolean hasValidPlatform() {
		return MULTIBLOCK.method_15332().validate(field_11863, method_11016().method_10074()) != null;
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10569(TAG_MANA, mana);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		mana = cmp.method_10550(TAG_MANA);
	}

	@Override
	public int getCurrentMana() {
		return mana;
	}

	@Override
	public boolean isFull() {
		ITerraPlateRecipe recipe = getCurrentRecipe(getInventory());
		return recipe == null || getCurrentMana() >= recipe.getMana();
	}

	@Override
	public void receiveMana(int mana) {
		this.mana = Math.max(0, this.mana + mana);
		field_11863.method_8455(field_11867, method_11010().method_26204());
	}

	@Override
	public boolean canReceiveManaFromBursts() {
		return isActive();
	}

	@Override
	public boolean canAttachSpark(class_1799 stack) {
		return true;
	}

	@Override
	public void attachSpark(ISparkEntity entity) {}

	@Override
	public ISparkEntity getAttachedSpark() {
		List<class_1297> sparks = field_11863.method_8390(class_1297.class, new class_238(field_11867.method_10084(), field_11867.method_10084().method_10069(1, 1, 1)), Predicates.instanceOf(ISparkEntity.class));
		if (sparks.size() == 1) {
			class_1297 e = sparks.get(0);
			return (ISparkEntity) e;
		}

		return null;
	}

	@Override
	public boolean areIncomingTranfersDone() {
		return !isActive();
	}

	@Override
	public int getAvailableSpaceForMana() {
		ITerraPlateRecipe recipe = getCurrentRecipe(getInventory());
		return recipe == null ? 0 : Math.max(0, recipe.getMana() - getCurrentMana());
	}

	public float getCompletion() {
		ITerraPlateRecipe recipe = getCurrentRecipe(getInventory());
		if (recipe == null) {
			return 0;
		}
		return ((float) getCurrentMana()) / recipe.getMana();
	}

	public int getComparatorLevel() {
		int val = (int) (getCompletion() * 15.0);
		if (getCurrentMana() > 0) {
			val = Math.max(val, 1);
		}
		return val;
	}

}
