/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import net.minecraft.class_3000;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.Botania;

public class TileStarfield extends TileMod implements class_3000 {
	public TileStarfield() {
		super(ModTiles.STARFIELD);
	}

	@Override
	public void method_16896() {
		if (field_11863.field_9236) {
			field_11863.method_8533(); // ensure isDayTime works properly by updating skylightSubtracted
			if (field_11863.method_8530()) {
				return;
			}

			double radius = 512;
			int iter = 2;
			for (int i = 0; i < iter; i++) {
				double x = field_11867.method_10263() + 0.5 + (Math.random() - 0.5) * radius;
				double y = Math.min(256, field_11867.method_10264() + Botania.proxy.getClientRenderDistance() * 16);
				double z = field_11867.method_10260() + 0.5 + (Math.random() - 0.5) * radius;

				float w = 0.6F;
				float c = 1F - w;

				float r = w + (float) Math.random() * c;
				float g = w + (float) Math.random() * c;
				float b = w + (float) Math.random() * c;

				float s = 20F + (float) Math.random() * 20F;
				int m = 50;

				SparkleParticleData data = SparkleParticleData.sparkle(s, r, g, b, m);
				Botania.proxy.addParticleForce(field_11863, data, x, y, z, 0, 0, 0);
			}
		}
	}

}
