/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1315;
import net.minecraft.class_1917;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_3000;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.entity.*;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.mixin.AccessorAbstractSpawner;

import java.util.Optional;

public class TileSpawnerClaw extends TileMod implements IManaReceiver, class_3000 {
	private static final String TAG_MANA = "mana";
	private static final int MAX_MANA = 160;

	private int mana = 0;

	public TileSpawnerClaw() {
		super(ModTiles.SPAWNER_CLAW);
	}

	@Override
	public void method_16896() {
		class_2586 tileBelow = field_11863.method_8321(field_11867.method_10074());
		if (mana >= 5 && tileBelow instanceof class_2636) {
			class_2636 spawner = (class_2636) tileBelow;
			class_1917 logic = spawner.method_11390();
			AccessorAbstractSpawner mLogic = (AccessorAbstractSpawner) logic;

			// [VanillaCopy] AbstractSpawner.tick, edits noted
			if (!mLogic.botania_isPlayerInRange()) { // Activate when vanilla is *not* running the spawner
				class_1937 world = this.method_10997();
				class_2338 blockpos = logic.method_8276();
				if (world.field_9236) {
					// Botania - use own particles
					if (Math.random() > 0.5) {
						WispParticleData data = WispParticleData.wisp((float) Math.random() / 3F, 0.6F - (float) Math.random() * 0.3F, 0.1F, 0.6F - (float) Math.random() * 0.3F, 2F);
						world.method_8406(data, method_11016().method_10263() + 0.3 + Math.random() * 0.5, method_11016().method_10264() - 0.3 + Math.random() * 0.25, method_11016().method_10260() + Math.random(), 0, -(-0.025F - 0.005F * (float) Math.random()), 0);
					}
					if (mLogic.getSpawnDelay() > 0) {
						mLogic.setSpawnDelay(mLogic.getSpawnDelay() - 1);
					}

					mLogic.setPrevMobRotation(mLogic.getMobRotation());
					mLogic.setMobRotation((mLogic.getMobRotation() + (double) (1000.0F / ((float) mLogic.getSpawnDelay() + 200.0F))) % 360.0D);
				} else {
					// Botania - consume mana
					this.mana -= 6;

					if (mLogic.getSpawnDelay() == -1) {
						mLogic.botania_updateSpawns();
					}

					if (mLogic.getSpawnDelay() > 0) {
						mLogic.setSpawnDelay(mLogic.getSpawnDelay() - 1);
						return;
					}

					boolean flag = false;

					for (int i = 0; i < mLogic.getSpawnCount(); ++i) {
						class_2487 compoundnbt = mLogic.getSpawnEntry().method_8678();
						Optional<class_1299<?>> optional = class_1299.method_17684(compoundnbt);
						if (!optional.isPresent()) {
							mLogic.botania_updateSpawns();
							return;
						}

						class_2499 listnbt = compoundnbt.method_10554("Pos", 6);
						int j = listnbt.size();
						double d0 = j >= 1 ? listnbt.method_10611(0) : (double) blockpos.method_10263() + (world.field_9229.nextDouble() - world.field_9229.nextDouble()) * (double) mLogic.getSpawnRange() + 0.5D;
						double d1 = j >= 2 ? listnbt.method_10611(1) : (double) (blockpos.method_10264() + world.field_9229.nextInt(3) - 1);
						double d2 = j >= 3 ? listnbt.method_10611(2) : (double) blockpos.method_10260() + (world.field_9229.nextDouble() - world.field_9229.nextDouble()) * (double) mLogic.getSpawnRange() + 0.5D;
						if (world.method_18026(optional.get().method_17683(d0, d1, d2))) {
							class_3218 serverWorld = (class_3218) world;
							class_1297 entity = class_1299.method_17842(compoundnbt, world, (p_221408_6_) -> {
								p_221408_6_.method_5808(d0, d1, d2, p_221408_6_.field_6031, p_221408_6_.field_5965);
								return p_221408_6_;
							});
							if (entity == null) {
								mLogic.botania_updateSpawns();
								return;
							}

							int k = world.method_18467(entity.getClass(), (new class_238((double) blockpos.method_10263(), (double) blockpos.method_10264(), (double) blockpos.method_10260(), (double) (blockpos.method_10263() + 1), (double) (blockpos.method_10264() + 1), (double) (blockpos.method_10260() + 1))).method_1014((double) mLogic.getSpawnRange())).size();
							if (k >= mLogic.getMaxNearbyEntities()) {
								mLogic.botania_updateSpawns();
								return;
							}

							entity.method_5808(entity.method_23317(), entity.method_23318(), entity.method_23321(), world.field_9229.nextFloat() * 360.0F, 0.0F);
							if (entity instanceof class_1308) {
								class_1308 mobentity = (class_1308) entity;
								if (!mobentity.method_5979(world, class_3730.field_16469) || !mobentity.method_5957(world)) {
									continue;
								}

								if (mLogic.getSpawnEntry().method_8678().method_10546() == 1 && mLogic.getSpawnEntry().method_8678().method_10573("id", 8)) {
									((class_1308) entity).method_5943(serverWorld, world.method_8404(entity.method_24515()), class_3730.field_16469, (class_1315) null, (class_2487) null);
								}

								serverWorld.method_30736(entity);
								world.method_20290(2004, blockpos, 0);
								if (entity instanceof class_1308) {
									((class_1308) entity).method_5990();
								}

								flag = true;
							}
						}
					}

					if (flag) {
						mLogic.botania_updateSpawns();
					}
				}
			}
		}
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10569(TAG_MANA, mana);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		mana = cmp.method_10550(TAG_MANA);
	}

	@Override
	public int getCurrentMana() {
		return mana;
	}

	@Override
	public boolean isFull() {
		return mana >= MAX_MANA;
	}

	@Override
	public void receiveMana(int mana) {
		this.mana = Math.min(3 * MAX_MANA, this.mana + mana);
	}

	@Override
	public boolean canReceiveManaFromBursts() {
		return true;
	}

}
