/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.common.item.ItemSparkUpgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public class TileSparkChanger extends TileExposedSimpleInventory {
	public TileSparkChanger() {
		super(ModTiles.SPARK_CHANGER);
	}

	public void doSwap() {
		if (field_11863.field_9236) {
			return;
		}

		class_1799 changeStack = getItemHandler().method_5438(0);
		List<ISparkAttachable> attachables = new ArrayList<>();
		for (class_2350 dir : class_2350.class_2353.field_11062) {
			class_2586 tile = field_11863.method_8321(field_11867.method_10093(dir));
			if (tile instanceof ISparkAttachable) {
				ISparkAttachable attach = (ISparkAttachable) tile;
				ISparkEntity spark = attach.getAttachedSpark();
				if (spark != null) {
					SparkUpgradeType upg = spark.getUpgrade();
					SparkUpgradeType newUpg = changeStack.method_7960() ? SparkUpgradeType.NONE : ((ItemSparkUpgrade) changeStack.method_7909()).type;
					if (upg != newUpg) {
						attachables.add(attach);
					}
				}
			}
		}

		if (attachables.size() > 0) {
			ISparkAttachable attach = attachables.get(field_11863.field_9229.nextInt(attachables.size()));
			ISparkEntity spark = attach.getAttachedSpark();
			SparkUpgradeType upg = spark.getUpgrade();
			class_1799 sparkStack = ItemSparkUpgrade.getByType(upg);
			SparkUpgradeType newUpg = changeStack.method_7960() ? SparkUpgradeType.NONE : ((ItemSparkUpgrade) changeStack.method_7909()).type;
			spark.setUpgrade(newUpg);
			Collection<ISparkEntity> transfers = spark.getTransfers();
			if (transfers != null) {
				transfers.clear();
			}
			getItemHandler().method_5447(0, sparkStack);
		}
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(1) {
			@Override
			public int method_5444() {
				return 1;
			}

			@Override
			public boolean method_5437(int index, class_1799 stack) {
				return !stack.method_7960() && stack.method_7909() instanceof ItemSparkUpgrade;
			}
		};
	}

	@Override
	public void method_5431() {
		super.method_5431();
		if (field_11863 != null && !field_11863.field_9236) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
	}

}
