/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import com.mojang.blaze3d.systems.RenderSystem;
import org.lwjgl.opengl.GL11;

import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.recipe.IRuneAltarRecipe;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.material.ItemRune;

import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3000;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class TileRuneAltar extends TileSimpleInventory implements IManaReceiver, class_3000 {
	private static final String TAG_MANA = "mana";
	private static final String TAG_MANA_TO_GET = "manaToGet";
	private static final int SET_KEEP_TICKS_EVENT = 0;
	private static final int SET_COOLDOWN_EVENT = 1;
	private static final int CRAFT_EFFECT_EVENT = 2;

	private IRuneAltarRecipe currentRecipe;

	public int manaToGet = 0;
	private int mana = 0;
	private int cooldown = 0;
	public int signal = 0;

	private List<class_1799> lastRecipe = null;
	private int recipeKeepTicks = 0;

	public TileRuneAltar() {
		super(ModTiles.RUNE_ALTAR);
	}

	public boolean addItem(@Nullable class_1657 player, class_1799 stack, @Nullable class_1268 hand) {
		if (cooldown > 0 || stack.method_7909() == ModItems.twigWand || stack.method_7909() == ModItems.lexicon) {
			return false;
		}

		if (stack.method_7909() == ModBlocks.livingrock.method_8389()) {
			if (!field_11863.field_9236) {
				class_1799 toSpawn = player != null && player.field_7503.field_7477 ? stack.method_7972().method_7971(1) : stack.method_7971(1);
				class_1542 item = new class_1542(field_11863, method_11016().method_10263() + 0.5, method_11016().method_10264() + 1, method_11016().method_10260() + 0.5, toSpawn);
				item.method_6982(40);
				item.method_18799(class_243.field_1353);
				field_11863.method_8649(item);
			}

			return true;
		}

		if (manaToGet != 0) {
			return false;
		}

		boolean did = false;

		for (int i = 0; i < inventorySize(); i++) {
			if (getItemHandler().method_5438(i).method_7960()) {
				did = true;
				class_1799 stackToAdd = stack.method_7972();
				stackToAdd.method_7939(1);
				getItemHandler().method_5447(i, stackToAdd);

				if (player == null || !player.field_7503.field_7477) {
					stack.method_7934(1);
				}

				break;
			}
		}

		if (did) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}

		return true;
	}

	@Override
	public boolean method_11004(int id, int param) {
		switch (id) {
		case SET_KEEP_TICKS_EVENT:
			recipeKeepTicks = param;
			return true;
		case SET_COOLDOWN_EVENT:
			cooldown = param;
			return true;
		case CRAFT_EFFECT_EVENT: {
			if (field_11863.field_9236) {
				for (int i = 0; i < 25; i++) {
					float red = (float) Math.random();
					float green = (float) Math.random();
					float blue = (float) Math.random();
					SparkleParticleData data = SparkleParticleData.sparkle((float) Math.random(), red, green, blue, 10);
					field_11863.method_8406(data, field_11867.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, field_11867.method_10264() + 1, field_11867.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0, 0, 0);
				}
				field_11863.method_8486(field_11867.method_10263(), field_11867.method_10264(), field_11867.method_10260(), ModSounds.runeAltarCraft, class_3419.field_15245, 1, 1, false);
			}
			return true;
		}
		default:
			return super.method_11004(id, param);
		}
	}

	@Override
	public void method_16896() {

		// Update every tick.
		receiveMana(0);

		if (!field_11863.field_9236) {
			if (manaToGet == 0) {
				List<class_1542> items = field_11863.method_18467(class_1542.class, new class_238(field_11867, field_11867.method_10069(1, 1, 1)));
				for (class_1542 item : items) {
					if (item.method_5805() && !item.method_6983().method_7960() && item.method_6983().method_7909() != ModBlocks.livingrock.method_8389()) {
						class_1799 stack = item.method_6983();
						addItem(null, stack, null);
					}
				}
			}

			int newSignal = 0;
			if (manaToGet > 0) {
				newSignal++;
				if (mana >= manaToGet) {
					newSignal++;
				}
			}

			if (newSignal != signal) {
				signal = newSignal;
				field_11863.method_8455(field_11867, method_11010().method_26204());
			}

			updateRecipe();
		} else {
			if (manaToGet > 0 && mana >= manaToGet && field_11863.field_9229.nextInt(20) == 0) {
				Vector3 vec = Vector3.fromTileEntityCenter(this);
				Vector3 endVec = vec.add(0, 2.5, 0);
				Botania.proxy.lightningFX(vec, endVec, 2F, 0x00948B, 0x00E4D7);
			}

			if (cooldown > 0) {
				WispParticleData data = WispParticleData.wisp(0.2F, 0.2F, 0.2F, 0.2F, 1);
				field_11863.method_8406(data, field_11867.method_10263() + Math.random(), field_11867.method_10264() + 0.8, field_11867.method_10260() + Math.random(), 0, - -0.025F, 0);
			}
		}

		if (cooldown > 0) {
			cooldown--;
		}

		if (recipeKeepTicks > 0) {
			--recipeKeepTicks;
		} else {
			lastRecipe = null;
		}
	}

	private void updateRecipe() {
		int manaToGet = this.manaToGet;

		getMana: {
			if (currentRecipe != null) {
				this.manaToGet = currentRecipe.getManaUsage();
			} else {
				Optional<IRuneAltarRecipe> maybeRecipe = field_11863.method_8433().method_8132(ModRecipeTypes.RUNE_TYPE, getItemHandler(), field_11863);
				if (maybeRecipe.isPresent()) {
					this.manaToGet = maybeRecipe.get().getManaUsage();
					break getMana;
				}
				this.manaToGet = 0;
			}
		}

		if (manaToGet != this.manaToGet) {
			field_11863.method_8396(null, field_11867, ModSounds.runeAltarStart, class_3419.field_15245, 1, 1);
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
	}

	private void saveLastRecipe() {
		lastRecipe = new ArrayList<>();
		for (int i = 0; i < inventorySize(); i++) {
			class_1799 stack = getItemHandler().method_5438(i);
			if (stack.method_7960()) {
				break;
			}
			lastRecipe.add(stack.method_7972());
		}
		recipeKeepTicks = 400;
		field_11863.method_8427(method_11016(), ModBlocks.runeAltar, SET_KEEP_TICKS_EVENT, 400);
	}

	public void trySetLastRecipe(class_1657 player) {
		TileAltar.tryToSetLastRecipe(player, getItemHandler(), lastRecipe);
		if (!isEmpty()) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
	}

	public void onWanded(class_1657 player, class_1799 wand) {
		if (field_11863.field_9236) {
			return;
		}

		IRuneAltarRecipe recipe = null;

		if (currentRecipe != null) {
			recipe = currentRecipe;
		} else {
			Optional<IRuneAltarRecipe> maybeRecipe = field_11863.method_8433().method_8132(ModRecipeTypes.RUNE_TYPE, getItemHandler(), field_11863);
			if (maybeRecipe.isPresent()) {
				recipe = maybeRecipe.get();
			}
		}

		if (recipe != null && manaToGet > 0 && mana >= manaToGet) {
			List<class_1542> items = field_11863.method_18467(class_1542.class, new class_238(field_11867, field_11867.method_10069(1, 1, 1)));
			class_1542 livingrock = null;
			for (class_1542 item : items) {
				if (item.method_5805() && !item.method_6983().method_7960() && item.method_6983().method_7909() == ModBlocks.livingrock.method_8389()) {
					livingrock = item;
					break;
				}
			}

			if (livingrock != null) {
				int mana = recipe.getManaUsage();
				receiveMana(-mana);
				class_1799 output = recipe.method_8116(getItemHandler());
				class_1542 outputItem = new class_1542(field_11863, field_11867.method_10263() + 0.5, field_11867.method_10264() + 1.5, field_11867.method_10260() + 0.5, output);
				field_11863.method_8649(outputItem);
				currentRecipe = null;
				field_11863.method_8427(method_11016(), ModBlocks.runeAltar, SET_COOLDOWN_EVENT, 60);
				field_11863.method_8427(method_11016(), ModBlocks.runeAltar, CRAFT_EFFECT_EVENT, 0);

				saveLastRecipe();
				for (int i = 0; i < inventorySize(); i++) {
					class_1799 stack = getItemHandler().method_5438(i);
					if (!stack.method_7960()) {
						if (stack.method_7909() instanceof ItemRune && (player == null || !player.field_7503.field_7477)) {
							class_1542 outputRune = new class_1542(field_11863, method_11016().method_10263() + 0.5, method_11016().method_10264() + 1.5, method_11016().method_10260() + 0.5, stack.method_7972());
							field_11863.method_8649(outputRune);
						}

						getItemHandler().method_5447(i, class_1799.field_8037);
					}
				}

				livingrock.method_6983().method_7934(1);
			}
		}
	}

	public boolean isEmpty() {
		for (int i = 0; i < inventorySize(); i++) {
			if (!getItemHandler().method_5438(i).method_7960()) {
				return false;
			}
		}

		return true;
	}

	@Override
	public void writePacketNBT(class_2487 tag) {
		super.writePacketNBT(tag);

		tag.method_10569(TAG_MANA, mana);
		tag.method_10569(TAG_MANA_TO_GET, manaToGet);
	}

	@Override
	public void readPacketNBT(class_2487 tag) {
		super.readPacketNBT(tag);

		mana = tag.method_10550(TAG_MANA);
		manaToGet = tag.method_10550(TAG_MANA_TO_GET);
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(16) {
			@Override
			public int method_5444() {
				return 1;
			}
		};
	}

	@Override
	public int getCurrentMana() {
		return mana;
	}

	@Override
	public boolean isFull() {
		return mana >= manaToGet;
	}

	@Override
	public void receiveMana(int mana) {
		this.mana = Math.min(this.mana + mana, manaToGet);
	}

	@Override
	public boolean canReceiveManaFromBursts() {
		return !isFull();
	}

	public void renderHUD(class_4587 ms, class_310 mc) {
		int xc = mc.method_22683().method_4486() / 2;
		int yc = mc.method_22683().method_4502() / 2;

		float angle = -90;
		int radius = 24;
		int amt = 0;
		for (int i = 0; i < inventorySize(); i++) {
			if (getItemHandler().method_5438(i).method_7960()) {
				break;
			}
			amt++;
		}

		if (amt > 0) {
			float anglePer = 360F / amt;
			field_11863.method_8433().method_8132(ModRecipeTypes.RUNE_TYPE, getItemHandler(), field_11863).ifPresent(recipe -> {
				RenderSystem.enableBlend();
				RenderSystem.enableRescaleNormal();
				RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

				float progress = (float) mana / (float) manaToGet;

				mc.method_1531().method_22813(HUDHandler.manaBar);
				RenderSystem.color4f(1F, 1F, 1F, 1F);
				RenderHelper.drawTexturedModalRect(ms, xc + radius + 9, yc - 8, progress == 1F ? 0 : 22, 8, 22, 15);

				if (progress == 1F) {
					mc.method_1480().method_4010(new class_1799(ModBlocks.livingrock), xc + radius + 16, yc + 8);
					// change to MatrixStack ops when renderItemIntoGUI starts taking MatrixStack
					RenderSystem.translated(0, 0, 100);
					mc.method_1480().method_4010(new class_1799(ModItems.twigWand), xc + radius + 24, yc + 8);
					RenderSystem.translated(0, 0, -100);
				}

				RenderHelper.renderProgressPie(ms, xc + radius + 32, yc - 8, progress, recipe.method_8116(getItemHandler()));

				if (progress == 1F) {
					mc.field_1772.method_1729(ms, "+", xc + radius + 14, yc + 12, 0xFFFFFF);
				}
			});

			for (int i = 0; i < amt; i++) {
				double xPos = xc + Math.cos(angle * Math.PI / 180D) * radius - 8;
				double yPos = yc + Math.sin(angle * Math.PI / 180D) * radius - 8;
				// change to MatrixStack ops when renderItemIntoGUI starts taking MatrixStack
				RenderSystem.translated(xPos, yPos, 0);
				mc.method_1480().method_4010(getItemHandler().method_5438(i), 0, 0);
				RenderSystem.translated(-xPos, -yPos, 0);

				angle += anglePer;
			}
		} else if (recipeKeepTicks > 0) {
			String s = class_1074.method_4662("botaniamisc.altarRefill0");
			mc.field_1772.method_1720(ms, s, xc - mc.field_1772.method_1727(s) / 2, yc + 10, 0xFFFFFF);
			s = class_1074.method_4662("botaniamisc.altarRefill1");
			mc.field_1772.method_1720(ms, s, xc - mc.field_1772.method_1727(s) / 2, yc + 20, 0xFFFFFF);
		}
	}

	public int getTargetMana() {
		return manaToGet;
	}

}
