/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BlockModFlower;
import vazkii.botania.common.block.BlockPylon;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ColorHelper;

import java.util.Random;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3000;

public class TilePylon extends class_2586 implements class_3000 {
	boolean activated = false;
	class_2338 centerPos;
	private int ticks = 0;

	public TilePylon() {
		super(ModTiles.PYLON);
	}

	@Override
	public void method_16896() {
		++ticks;

		if (!(method_11010().method_26204() instanceof BlockPylon)) {
			return;
		}

		BlockPylon.Variant variant = ((BlockPylon) method_11010().method_26204()).variant;

		if (activated && field_11863.field_9236) {
			if (field_11863.method_8320(centerPos).method_26204() != variant.targetBlock
					|| variant == BlockPylon.Variant.NATURA && (portalOff() || !(field_11863.method_8320(method_11016().method_10074()).method_26204() instanceof BlockPool))) {
				activated = false;
				return;
			}

			class_243 centerBlock = new class_243(centerPos.method_10263() + 0.5, centerPos.method_10264() + 0.75 + (Math.random() - 0.5 * 0.25), centerPos.method_10260() + 0.5);

			if (variant == BlockPylon.Variant.NATURA) {
				if (ConfigHandler.CLIENT.elfPortalParticlesEnabled.getValue()) {
					double worldTime = ticks;
					worldTime += new Random(field_11867.hashCode()).nextInt(1000);
					worldTime /= 5;

					float r = 0.75F + (float) Math.random() * 0.05F;
					double x = field_11867.method_10263() + 0.5 + Math.cos(worldTime) * r;
					double z = field_11867.method_10260() + 0.5 + Math.sin(worldTime) * r;

					class_243 ourCoords = new class_243(x, field_11867.method_10264() + 0.25, z);
					centerBlock = centerBlock.method_1023(0, 0.5, 0);
					class_243 movementVector = centerBlock.method_1020(ourCoords).method_1029().method_1021(0.2);

					WispParticleData data = WispParticleData.wisp(0.25F + (float) Math.random() * 0.1F, (float) Math.random() * 0.25F, 0.75F + (float) Math.random() * 0.25F, (float) Math.random() * 0.25F, 1);
					field_11863.method_8406(data, x, field_11867.method_10264() + 0.25, z, 0, -(-0.075F - (float) Math.random() * 0.015F), 0);
					if (field_11863.field_9229.nextInt(3) == 0) {
						WispParticleData data1 = WispParticleData.wisp(0.25F + (float) Math.random() * 0.1F, (float) Math.random() * 0.25F, 0.75F + (float) Math.random() * 0.25F, (float) Math.random() * 0.25F);
						field_11863.method_8406(data1, x, field_11867.method_10264() + 0.25, z, (float) movementVector.field_1352, (float) movementVector.field_1351, (float) movementVector.field_1350);
					}
				}
			} else {
				class_243 ourCoords = class_243.method_24953(method_11016()).method_1031(0, 1 + (Math.random() - 0.5 * 0.25), 0);
				class_243 movementVector = centerBlock.method_1020(ourCoords).method_1029().method_1021(0.2);

				class_2248 block = field_11863.method_8320(field_11867.method_10074()).method_26204();
				if (block instanceof BlockModFlower) {
					int hex = ColorHelper.getColorValue(((BlockModFlower) block).color);
					int r = (hex & 0xFF0000) >> 16;
					int g = (hex & 0xFF00) >> 8;
					int b = hex & 0xFF;

					if (field_11863.field_9229.nextInt(4) == 0) {
						SparkleParticleData data = SparkleParticleData.sparkle((float) Math.random(), r / 255F, g / 255F, b / 255F, 8);
						field_11863.method_8406(data, centerBlock.field_1352 + (Math.random() - 0.5) * 0.5, centerBlock.field_1351, centerBlock.field_1350 + (Math.random() - 0.5) * 0.5, 0, 0, 0);
					}

					WispParticleData data1 = WispParticleData.wisp((float) Math.random() / 3F, r / 255F, g / 255F, b / 255F, 1);
					field_11863.method_8406(data1, field_11867.method_10263() + 0.5 + (Math.random() - 0.5) * 0.25, field_11867.method_10264() - 0.5, field_11867.method_10260() + 0.5 + (Math.random() - 0.5) * 0.25, 0, - -0.04F, 0);
					WispParticleData data = WispParticleData.wisp((float) Math.random() / 5F, r / 255F, g / 255F, b / 255F, 1);
					field_11863.method_8406(data, field_11867.method_10263() + 0.5 + (Math.random() - 0.5) * 0.125, field_11867.method_10264() + 1.5, field_11867.method_10260() + 0.5 + (Math.random() - 0.5) * 0.125, 0, - -0.001F, 0);
					WispParticleData data2 = WispParticleData.wisp((float) Math.random() / 8F, r / 255F, g / 255F, b / 255F);
					field_11863.method_8406(data2, field_11867.method_10263() + 0.5 + (Math.random() - 0.5) * 0.25, field_11867.method_10264() + 1.5, field_11867.method_10260() + 0.5 + (Math.random() - 0.5) * 0.25, (float) movementVector.field_1352, (float) movementVector.field_1351, (float) movementVector.field_1350);
				}
			}
		}

		if (field_11863.field_9229.nextBoolean() && field_11863.field_9236) {
			SparkleParticleData data = SparkleParticleData.sparkle((float) Math.random(), variant.r, variant.g, variant.b, 2);
			field_11863.method_8406(data, field_11867.method_10263() + Math.random(), field_11867.method_10264() + Math.random() * 1.5, field_11867.method_10260() + Math.random(), 0, 0, 0);
		}
	}

	private boolean portalOff() {
		return field_11863.method_8320(centerPos).method_26204() != ModBlocks.alfPortal
				|| field_11863.method_8320(centerPos).method_11654(BotaniaStateProps.ALFPORTAL_STATE) == AlfPortalState.OFF;
	}

}
