/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_638;
import javax.annotation.Nullable;

public class TilePlatform extends TileMod implements RenderAttachmentBlockEntity {
	private static final String TAG_CAMO = "camo";

	@Nullable
	private class_2680 camoState;

	public TilePlatform() {
		super(ModTiles.PLATFORM);
	}

	public boolean onWanded(class_1657 player) {
		if (player != null) {
			if (getCamoState() == null || player.method_5715()) {
				swapSelfAndPass(this, true);
			} else {
				swapSurroudings(this, false);
			}
			return true;
		}

		return false;
	}

	@Nullable
	public class_2680 getCamoState() {
		return camoState;
	}

	public void setCamoState(@Nullable class_2680 state) {
		this.camoState = state;

		if (field_11863 != null) {
			field_11863.method_8413(method_11016(), method_11010(), method_11010(), 3);
			if (!field_11863.field_9236) {
				field_11863.method_8408(field_11867, method_11010().method_26204());
			}
		}
	}

	private void swapSelfAndPass(TilePlatform tile, boolean empty) {
		swap(tile, empty);
		swapSurroudings(tile, empty);
	}

	private void swapSurroudings(TilePlatform tile, boolean empty) {
		for (class_2350 dir : class_2350.values()) {
			class_2338 pos = tile.method_11016().method_10093(dir);
			class_2586 tileAt = field_11863.method_8321(pos);
			if (tileAt instanceof TilePlatform) {
				TilePlatform platform = (TilePlatform) tileAt;
				if (empty == (platform.getCamoState() != null)) {
					swapSelfAndPass(platform, empty);
				}
			}
		}
	}

	private void swap(TilePlatform tile, boolean empty) {
		tile.setCamoState(empty ? null : getCamoState());
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		if (getCamoState() != null) {
			cmp.method_10566(TAG_CAMO, class_2512.method_10686(getCamoState()));
		}
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		class_2680 state = class_2512.method_10681(cmp.method_10562(TAG_CAMO));
		if (state.method_26215()) {
			state = null;
		}
		setCamoState(state);
	}

	@Override
	public void fromClientTag(class_2487 tag) {
		super.fromClientTag(tag);
		if (field_11863 instanceof class_638) {
			field_11863.method_8413(method_11016(), method_11010(), method_11010(), 0);
		}
	}

	@Override
	public Object getRenderAttachmentData() {
		return new PlatformData(method_11016(), camoState);
	}

	public static class PlatformData {
		public final class_2338 pos;

		@Nullable
		public final class_2680 state;

		public PlatformData(class_2338 pos, @Nullable class_2680 state) {
			this.pos = pos.method_10062();
			this.state = state;
		}
	}
}
