/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import vazkii.botania.mixin.AccessorItemEntity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1277;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_3000;

public class TileOpenCrate extends TileExposedSimpleInventory implements class_3000 {
	public TileOpenCrate() {
		this(ModTiles.OPEN_CRATE);
	}

	public TileOpenCrate(class_2591<?> type) {
		super(type);
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(1);
	}

	@Override
	public void method_16896() {
		if (field_11863.field_9236) {
			return;
		}

		boolean redstone = false;
		for (class_2350 dir : class_2350.values()) {
			int redstoneSide = field_11863.method_8499(field_11867.method_10093(dir), dir);
			if (redstoneSide > 0) {
				redstone = true;
				break;
			}
		}

		if (canEject()) {
			class_1799 stack = getItemHandler().method_5438(0);
			if (!stack.method_7960()) {
				eject(stack, redstone);
			}
		}
	}

	public boolean canEject() {
		float width = class_1299.field_6052.method_17685();
		float height = class_1299.field_6052.method_17686();

		double ejectX = field_11867.method_10263() + 0.5;
		double ejectY = field_11867.method_10264() - height;
		double ejectZ = field_11867.method_10260() + 0.5;
		class_238 itemBB = new class_238(ejectX - width / 2, ejectY, ejectZ - width / 2, ejectX + width / 2, ejectY + height, ejectZ + width / 2);
		return field_11863.method_18026(itemBB);
	}

	public void eject(class_1799 stack, boolean redstone) {
		double ejectY = field_11867.method_10264() - class_1299.field_6052.method_17686();
		class_1542 item = new class_1542(field_11863, field_11867.method_10263() + 0.5, ejectY, field_11867.method_10260() + 0.5, stack);
		item.method_18799(class_243.field_1353);
		if (redstone) {
			((AccessorItemEntity) item).setAge(-200);
		}

		getItemHandler().method_5447(0, class_1799.field_8037);
		field_11863.method_8649(item);
	}

	@Override
	public boolean method_5493(int index, @Nonnull class_1799 stack, @Nullable class_2350 direction) {
		return false;
	}
}
