/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1684;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3000;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5275;
import net.minecraft.entity.*;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.wand.IWandBindable;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BlockLightRelay;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.network.PacketSpawnEntity;

import javax.annotation.Nonnull;

import java.util.ArrayList;
import java.util.List;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class TileLightRelay extends TileMod implements class_3000, IWandBindable {
	public static final int MAX_DIST = 20;

	private static final String TAG_BIND_X = "bindX";
	private static final String TAG_BIND_Y = "bindY";
	private static final String TAG_BIND_Z = "bindZ";

	private class_2338 bindPos = new class_2338(0, -1, 0);
	private int ticksElapsed = 0;

	public TileLightRelay() {
		super(ModTiles.LIGHT_RELAY);
	}

	public void mountEntity(class_1297 e) {
		class_2338 nextDest = getNextDestination();
		if (e.method_5765() || field_11863.field_9236 || nextDest == null || !isValidBinding()) {
			return;
		}

		EntityPlayerMover mover = new EntityPlayerMover(field_11863, field_11867, nextDest);
		field_11863.method_8649(mover);
		e.method_5804(mover);
		if (!(e instanceof class_1542)) {
			mover.method_5783(ModSounds.lightRelay, 0.2F, (float) Math.random() * 0.3F + 0.7F);
		}
		if (e instanceof class_3222) {
			PlayerHelper.grantCriterion((class_3222) e, prefix("main/luminizer_ride"), "code_triggered");
		}
	}

	@Override
	public void method_16896() {
		ticksElapsed++;

		class_2338 nextDest = getNextDestination();
		if (nextDest != null && nextDest.method_10264() > -1 && isValidBinding()) {
			if (field_11863.field_9236) {
				Vector3 vec = getMovementVector();
				if (vec != null) {
					double dist = 0.1;
					int size = (int) (vec.mag() / dist);
					int count = 10;
					int start = ticksElapsed % size;

					Vector3 vecMag = vec.normalize().multiply(dist);
					Vector3 vecTip = vecMag.multiply(start).add(field_11867.method_10263() + 0.5, field_11867.method_10264() + 0.5, field_11867.method_10260() + 0.5);

					double radPer = Math.PI / 16.0;
					float mul = 0.5F;
					float mulPer = 0.4F;
					float maxMul = 2;
					WispParticleData data = WispParticleData.wisp(0.1F, 0.4F, 0.4F, 1F, 1);
					for (int i = start; i < start + count; i++) {
						mul = Math.min(maxMul, mul + mulPer);
						double rad = radPer * (i + ticksElapsed * 0.4);
						Vector3 vecRot = vecMag.crossProduct(Vector3.ONE).multiply(mul).rotate(rad, vecMag).add(vecTip);
						field_11863.method_8406(data, vecRot.x, vecRot.y, vecRot.z, (float) -vecMag.x, (float) -vecMag.y, (float) -vecMag.z);
						vecTip = vecTip.add(vecMag);
					}
				}
			} else {
				class_2338 endpoint = getEndpoint();

				if (endpoint != null) {
					class_238 aabb = method_11010().method_26218(field_11863, field_11867).method_1107().method_996(field_11867);
					float range = 0.6F;
					List<class_1684> enderPearls = field_11863.method_18467(class_1684.class, aabb.method_1014(range));
					for (class_1684 pearl : enderPearls) {
						pearl.method_5859(
								endpoint.method_10263() + pearl.method_23317() - field_11867.method_10263(),
								endpoint.method_10264() + pearl.method_23318() - field_11867.method_10264(),
								endpoint.method_10260() + pearl.method_23321() - field_11867.method_10260()
						);
					}
				}
			}
		}
	}

	private boolean isValidBinding() {
		class_2338 nextDest = getNextDestination();
		if (nextDest == null) {
			return false;
		}

		class_2248 block = field_11863.method_8320(nextDest).method_26204();
		return block instanceof BlockLightRelay;
	}

	private class_2338 getEndpoint() {
		List<TileLightRelay> pointsPassed = new ArrayList<>();
		TileLightRelay relay = this;
		class_2338 lastCoords = null;

		// Doing while(true) gives an unreachable code error
		boolean run = true;
		while (run) {
			if (pointsPassed.contains(relay)) {
				return null; // Circular path
			}
			pointsPassed.add(relay);

			class_2338 coords = relay.getNextDestination();
			if (coords == null) {
				return lastCoords;
			}

			class_2586 tile = field_11863.method_8321(coords);
			if (tile != null && tile instanceof TileLightRelay) {
				relay = (TileLightRelay) tile;
			} else {
				return lastCoords;
			}

			lastCoords = coords;
		}

		return null;
	}

	public Vector3 getMovementVector() {
		class_2338 dest = getNextDestination();
		if (dest == null) {
			return null;
		}

		return new Vector3(dest.method_10263() - field_11867.method_10263(), dest.method_10264() - field_11867.method_10264(), dest.method_10260() - field_11867.method_10260());
	}

	@Override
	public class_2338 getBinding() {
		return bindPos;
	}

	public class_2338 getNextDestination() {
		class_2680 state = method_11010();
		if (state.method_26204() == ModBlocks.lightRelayToggle && state.method_11654(class_2741.field_12484)) {
			return null;
		} else if (state.method_26204() == ModBlocks.lightRelayFork) {
			class_2338 torchPos = null;
			for (int i = -2; i < 3; i++) {
				class_2338 testPos = field_11867.method_10069(0, i, 0);

				class_2680 testState = field_11863.method_8320(testPos);
				if (testState.method_26204() == ModBlocks.animatedTorch) {
					torchPos = testPos;
					break;
				}
			}

			if (torchPos != null) {
				TileAnimatedTorch torch = (TileAnimatedTorch) field_11863.method_8321(torchPos);
				class_2350 side = TileAnimatedTorch.SIDES[torch.side].method_10153();
				for (int i = 1; i < MAX_DIST; i++) {
					class_2338 testPos = field_11867.method_10079(side, i);
					class_2680 testState = field_11863.method_8320(testPos);
					if (testState.method_26204() instanceof BlockLightRelay) {
						return testPos;
					}
				}
			}
		}

		return getBinding();
	}

	@Override
	public boolean canSelect(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
		return true;
	}

	@Override
	public boolean bindTo(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
		if (!(player.field_6002.method_8320(pos).method_26204() instanceof BlockLightRelay)
				|| pos.method_10262(method_11016()) > MAX_DIST * MAX_DIST) {
			return false;
		}

		bindPos = pos;
		VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		return true;
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		bindPos = new class_2338(
				cmp.method_10550(TAG_BIND_X),
				cmp.method_10550(TAG_BIND_Y),
				cmp.method_10550(TAG_BIND_Z)
		);
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10569(TAG_BIND_X, bindPos.method_10263());
		cmp.method_10569(TAG_BIND_Y, bindPos.method_10264());
		cmp.method_10569(TAG_BIND_Z, bindPos.method_10260());
	}

	public static class EntityPlayerMover extends class_1297 {
		private static final String TAG_EXIT_X = "exitX";
		private static final String TAG_EXIT_Y = "exitY";
		private static final String TAG_EXIT_Z = "exitZ";
		private static final class_2940<class_2338> EXIT_POS = class_2945.method_12791(EntityPlayerMover.class, class_2943.field_13324);

		public EntityPlayerMover(class_1299<EntityPlayerMover> type, class_1937 world) {
			super(type, world);
			field_5960 = true;
		}

		public EntityPlayerMover(class_1937 world, class_2338 pos, class_2338 exitPos) {
			this(ModEntities.PLAYER_MOVER, world);
			method_5814(pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5);
			setExit(exitPos);
		}

		@Override
		protected void method_5693() {
			field_6011.method_12784(EXIT_POS, class_2338.field_10980);
		}

		@Override
		public void method_5773() {
			super.method_5773();

			if (method_5685().isEmpty() && !field_6002.field_9236) {
				method_5650();
				return;
			}

			boolean isItem = method_5854() instanceof class_1542;
			if (!isItem && field_6012 % 30 == 0) {
				method_5783(ModSounds.lightRelay, 0.05F, (float) Math.random() * 0.3F + 0.7F);
			}

			class_2338 pos = method_24515();
			class_2338 exitPos = getExitPos();

			if (pos.equals(exitPos)) {
				class_2586 tile = field_6002.method_8321(pos);
				if (tile instanceof TileLightRelay) {
					class_2680 state = field_6002.method_8320(pos);
					if (state.method_26204() == ModBlocks.lightRelayDetector) {
						field_6002.method_8501(pos, state.method_11657(class_2741.field_12484, true));
						field_6002.method_8397().method_8676(pos, state.method_26204(), 2);
					}

					TileLightRelay relay = (TileLightRelay) tile;
					class_2338 bind = relay.getNextDestination();
					if (bind != null && relay.isValidBinding()) {
						setExit(bind);
						return;
					}
				}

				for (class_1297 e : method_5685()) {
					e.method_5848();
				}
				method_5650();
			} else {
				class_243 thisVec = method_19538();
				class_243 motVec = thisVec.method_22882().method_1031(exitPos.method_10263() + 0.5, exitPos.method_10264() + 0.5, exitPos.method_10260() + 0.5).method_1029().method_1021(0.5);

				int color;

				int count = 4;
				for (int i = 0; i < count; i++) {
					color = class_3532.method_15369(field_6012 / 36F + 1F / count * i, 1F, 1F);
					double rad = Math.PI * 2.0 / count * i + field_6012 / Math.PI;
					double cos = Math.cos(rad);
					double sin = Math.sin(rad);
					double s = 0.4;

					int r = (color >> 16) & 0xFF;
					int g = (color >> 8) & 0xFF;
					int b = color & 0xFF;
					SparkleParticleData data = SparkleParticleData.sparkle(1.2F, r / 255F, g / 255F, b / 255F, 10);
					field_6002.method_8406(data, method_23317() + cos * s, method_23318() - 0.5, method_23321() + sin * s, 0, 0, 0);
				}

				method_5814(method_23317() + motVec.field_1352, method_23318() + motVec.field_1351, method_23321() + motVec.field_1350);
			}
		}

		/* todo 1.16-fabric
		@Override
		public boolean shouldRiderSit() {
			return false;
		}
		*/

		@Override
		public boolean method_5643(@Nonnull class_1282 source, float damage) {
			return false;
		}

		@Override
		protected void method_5749(@Nonnull class_2487 cmp) {
			setExit(new class_2338(cmp.method_10550(TAG_EXIT_X), cmp.method_10550(TAG_EXIT_Y), cmp.method_10550(TAG_EXIT_Z)));
		}

		@Override
		protected void method_5652(@Nonnull class_2487 cmp) {
			class_2338 exit = getExitPos();
			cmp.method_10569(TAG_EXIT_X, exit.method_10263());
			cmp.method_10569(TAG_EXIT_Y, exit.method_10264());
			cmp.method_10569(TAG_EXIT_Z, exit.method_10260());
		}

		// [VanillaCopy] PigEntity logic to select a dismount location
		@Override
		public class_243 method_24829(class_1309 living) {
			class_2350 direction = living.method_5735();
			int[][] aint = class_5275.method_27934(direction);
			class_2338 blockpos = this.method_24515();
			class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();

			for (class_4050 pose : living.method_24831()) {
				class_238 axisalignedbb = living.method_24833(pose);

				for (int[] aint1 : aint) {
					blockpos$mutable.method_10103(blockpos.method_10263() + aint1[0], blockpos.method_10264(), blockpos.method_10260() + aint1[1]);
					double d0 = this.field_6002.method_30347(blockpos$mutable);
					if (class_5275.method_27932(d0)) {
						class_243 vector3d = class_243.method_26410(blockpos$mutable, d0);
						if (class_5275.method_27933(this.field_6002, living, axisalignedbb.method_997(vector3d))) {
							living.method_18380(pose);
							return vector3d;
						}
					}
				}
			}

			return super.method_24829(living);
		}

		@Nonnull
		@Override
		public class_2596<?> method_18002() {
			return PacketSpawnEntity.make(this);
		}

		public class_2338 getExitPos() {
			return field_6011.method_12789(EXIT_POS);
		}

		public void setExit(class_2338 pos) {
			field_6011.method_12778(EXIT_POS, pos);
		}

	}

}
