/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.brew.ItemIncenseStick;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2741;
import net.minecraft.class_3000;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import java.util.List;
import java.util.Random;

public class TileIncensePlate extends TileExposedSimpleInventory implements class_1278, class_3000 {
	private static final String TAG_TIME_LEFT = "timeLeft";
	private static final String TAG_BURNING = "burning";
	private static final int RANGE = 32;

	private int timeLeft = 0;
	public boolean burning = false;
	public int comparatorOutput = 0;

	public TileIncensePlate() {
		super(ModTiles.INCENSE_PLATE);
	}

	@Override
	public void method_16896() {
		class_1799 stack = getItemHandler().method_5438(0);
		if (!stack.method_7960() && burning) {
			if (method_11010().method_11654(class_2741.field_12508) && timeLeft > 1) {
				timeLeft = 1;
				spawnSmokeParticles();
			}

			Brew brew = ((ItemIncenseStick) ModItems.incenseStick).getBrew(stack);
			class_1293 effect = brew.getPotionEffects(stack).get(0);
			if (timeLeft > 0) {
				timeLeft--;
				if (!field_11863.field_9236) {
					List<class_1657> players = field_11863.method_18467(class_1657.class, new class_238(field_11867.method_10263() + 0.5 - RANGE, field_11867.method_10264() + 0.5 - RANGE, field_11867.method_10260() + 0.5 - RANGE, field_11867.method_10263() + 0.5 + RANGE, field_11867.method_10264() + 0.5 + RANGE, field_11867.method_10260() + 0.5 + RANGE));
					for (class_1657 player : players) {
						class_1293 currentEffect = player.method_6112(effect.method_5579());
						boolean nightVision = effect.method_5579() == class_1294.field_5925;
						if (currentEffect == null || currentEffect.method_5584() < (nightVision ? 205 : 3)) {
							class_1293 applyEffect = new class_1293(effect.method_5579(), nightVision ? 285 : 80, effect.method_5578(), true, true);
							player.method_6092(applyEffect);
						}
					}

					if (field_11863.field_9229.nextInt(20) == 0) {
						field_11863.method_8396(null, field_11867, class_3417.field_14993, class_3419.field_15245, 0.1F, 1);
					}
				} else {
					double x = field_11867.method_10263() + 0.5;
					double y = field_11867.method_10264() + 0.5;
					double z = field_11867.method_10260() + 0.5;

					int color = brew.getColor(stack);
					float r = (color >> 16 & 0xFF) / 255F;
					float g = (color >> 8 & 0xFF) / 255F;
					float b = (color & 0xFF) / 255F;

					WispParticleData data1 = WispParticleData.wisp(0.05F + (float) Math.random() * 0.02F, r, g, b);
					field_11863.method_8406(data1, x - (Math.random() - 0.5) * 0.2, y - (Math.random() - 0.5) * 0.2, z - (Math.random() - 0.5) * 0.2, 0.005F - (float) Math.random() * 0.01F, 0.01F + (float) Math.random() * 0.005F, 0.005F - (float) Math.random() * 0.01F);
					WispParticleData data = WispParticleData.wisp(0.05F + (float) Math.random() * 0.02F, 0.2F, 0.2F, 0.2F);
					field_11863.method_8406(data, x - (Math.random() - 0.5) * 0.2, y - (Math.random() - 0.5) * 0.2, z - (Math.random() - 0.5) * 0.2, 0.005F - (float) Math.random() * 0.01F, 0.01F + (float) Math.random() * 0.001F, 0.005F - (float) Math.random() * 0.01F);
				}
			} else {
				getItemHandler().method_5447(0, class_1799.field_8037);
				burning = false;
				VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
			}
		} else {
			timeLeft = 0;
		}

		int newComparator = 0;
		if (!stack.method_7960()) {
			newComparator = 1;
		}
		if (burning) {
			newComparator = 2;
		}
		if (comparatorOutput != newComparator) {
			comparatorOutput = newComparator;
			field_11863.method_8455(field_11867, method_11010().method_26204());
		}
	}

	public void spawnSmokeParticles() {
		Random random = field_11863.method_8409();
		for (int i = 0; i < 4; ++i) {
			field_11863.method_8406(class_2398.field_11251,
					field_11867.method_10263() + 0.5 + random.nextDouble() / 2.0 * (random.nextBoolean() ? 1 : -1),
					field_11867.method_10264() + 1,
					field_11867.method_10260() + 0.5 + random.nextDouble() / 2.0 * (random.nextBoolean() ? 1 : -1),
					0.0D,
					0.05D,
					0.0D);
		}
		field_11863.method_8396(null, field_11867, class_3417.field_15222, class_3419.field_15245, 0.1F, 1.0F);
	}

	public void ignite() {
		class_1799 stack = getItemHandler().method_5438(0);

		if (stack.method_7960() || burning) {
			return;
		}

		if (method_11010().method_11654(class_2741.field_12508)) {
			spawnSmokeParticles();
			return;
		}

		burning = true;
		Brew brew = ((ItemIncenseStick) ModItems.incenseStick).getBrew(stack);
		timeLeft = brew.getPotionEffects(stack).get(0).method_5584() * ItemIncenseStick.TIME_MULTIPLIER;
	}

	@Override
	public void writePacketNBT(class_2487 tag) {
		super.writePacketNBT(tag);
		tag.method_10569(TAG_TIME_LEFT, timeLeft);
		tag.method_10556(TAG_BURNING, burning);
	}

	@Override
	public void readPacketNBT(class_2487 tag) {
		super.readPacketNBT(tag);
		timeLeft = tag.method_10550(TAG_TIME_LEFT);
		burning = tag.method_10577(TAG_BURNING);
	}

	public boolean acceptsItem(class_1799 stack) {
		return !stack.method_7960() && stack.method_7909() == ModItems.incenseStick && ((ItemIncenseStick) ModItems.incenseStick).getBrew(stack) != ModBrews.fallbackBrew;
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(1) {
			@Override
			public boolean method_5437(int index, class_1799 stack) {
				return acceptsItem(stack);
			}
		};
	}

	@Override
	public void method_5431() {
		super.method_5431();
		if (field_11863 != null && !field_11863.field_9236) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
	}

	@Override
	public boolean method_5493(int index, @Nonnull class_1799 stack, @Nullable class_2350 direction) {
		return false;
	}
}
