/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3000;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_4587;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IHourglassTrigger;
import vazkii.botania.common.item.ModItems;

public class TileHourglass extends TileExposedSimpleInventory implements class_3000 {
	private static final String TAG_TIME = "time";
	private static final String TAG_TIME_FRACTION = "timeFraction";
	private static final String TAG_FLIP = "flip";
	private static final String TAG_FLIP_TICKS = "flipTicks";
	private static final String TAG_LOCK = "lock";
	private static final String TAG_MOVE = "move";

	private int time = 0;
	public float timeFraction = 0F;
	public float lastFraction = 0;
	public boolean flip = false;
	public int flipTicks = 0;
	public boolean lock = false;
	public boolean move = true;

	public TileHourglass() {
		super(ModTiles.HOURGLASS);
	}

	private boolean isDust() {
		class_1799 stack = getItemHandler().method_5438(0);
		return !stack.method_7960() && stack.method_7909() == ModItems.manaPowder;
	}

	@Override
	public void method_16896() {
		int totalTime = getTotalTime();
		boolean dust = isDust();

		if (totalTime > 0 || dust) {
			if (move && !dust) {
				time++;
			}

			if (time >= totalTime) {
				time = 0;
				flip = !flip;
				flipTicks = 4;
				if (!field_11863.field_9236) {
					field_11863.method_8652(method_11016(), method_11010().method_11657(class_2741.field_12484, true), 1);
					field_11863.method_8397().method_8676(field_11867, method_11010().method_26204(), 4);
				}

				for (class_2350 facing : class_2350.values()) {
					class_2338 pos = method_11016().method_10093(facing);
					class_2680 state = field_11863.method_8320(pos);
					if (state.method_26204() instanceof IHourglassTrigger) {
						((IHourglassTrigger) state.method_26204()).onTriggeredByHourglass(field_11863, pos, this);
					}
				}
			}

			lastFraction = timeFraction;
			timeFraction = (float) time / (float) totalTime;
		} else {
			time = 0;
			lastFraction = 0F;
			timeFraction = 0F;
		}

		if (flipTicks > 0) {
			flipTicks--;
		}
	}

	public void onManaCollide() {
		if (!field_11863.field_9236) {
			if (isDust()) {
				time++;
			} else {
				move = !move;
			}
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
	}

	public int getTotalTime() {
		class_1799 stack = getItemHandler().method_5438(0);
		if (stack.method_7960()) {
			return 0;
		}

		return getStackItemTime(stack) * stack.method_7947();
	}

	public static int getStackItemTime(class_1799 stack) {
		if (stack.method_7960()) {
			return 0;
		}
		if (stack.method_7909() == class_2246.field_10102.method_8389()) {
			return 20;
		}
		if (stack.method_7909() == class_2246.field_10534.method_8389()) {
			return 200;
		}
		if (stack.method_7909() == class_2246.field_10114.method_8389()) {
			return 1200;
		}
		if (stack.method_7909() == ModItems.manaPowder) {
			return 1;
		}
		return 0;
	}

	public int getColor() {
		class_1799 stack = getItemHandler().method_5438(0);
		if (stack.method_7960()) {
			return 0;
		}
		if (stack.method_7909() == class_2246.field_10102.method_8389()) {
			return 0xFFEC49;
		}
		if (stack.method_7909() == class_2246.field_10534.method_8389()) {
			return 0xE95800;
		}
		if (stack.method_7909() == class_2246.field_10114.method_8389()) {
			return 0x5A412f;
		}
		if (stack.method_7909() == ModItems.manaPowder) {
			return 0x03abff;
		}

		return 0;
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(1) {
			@Override
			public boolean method_5437(int index, class_1799 stack) {
				return !stack.method_7960() && (stack.method_7909() == class_2246.field_10102.method_8389()
						|| stack.method_7909() == class_2246.field_10534.method_8389()
						|| stack.method_7909() == class_2246.field_10114.method_8389()
						|| stack.method_7909() == ModItems.manaPowder);
			}
		};
	}

	@Override
	public void method_5431() {
		super.method_5431();
		if (field_11863 != null && !field_11863.field_9236) {
			time = 0;
			timeFraction = 0F;
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(TileHourglass.this);
		}
	}

	@Override
	public void writePacketNBT(class_2487 tag) {
		super.writePacketNBT(tag);
		tag.method_10569(TAG_TIME, time);
		tag.method_10548(TAG_TIME_FRACTION, timeFraction);
		tag.method_10556(TAG_FLIP, flip);
		tag.method_10569(TAG_FLIP_TICKS, flipTicks);
		tag.method_10556(TAG_MOVE, move);
		tag.method_10556(TAG_LOCK, lock);
	}

	@Override
	public void readPacketNBT(class_2487 tag) {
		super.readPacketNBT(tag);
		time = tag.method_10550(TAG_TIME);
		timeFraction = tag.method_10583(TAG_TIME_FRACTION);
		flip = tag.method_10577(TAG_FLIP);
		flipTicks = tag.method_10550(TAG_FLIP_TICKS);
		move = tag.method_10577(TAG_MOVE);
		lock = tag.method_10577(TAG_LOCK);
	}

	@Environment(EnvType.CLIENT)
	public void renderHUD(class_4587 ms) {
		class_310 mc = class_310.method_1551();
		int x = mc.method_22683().method_4486() / 2 + 10;
		int y = mc.method_22683().method_4502() / 2 - 10;

		class_1799 stack = getItemHandler().method_5438(0);
		if (!stack.method_7960()) {
			mc.method_1480().method_4010(stack, x, y);
			mc.method_1480().method_4025(mc.field_1772, stack, x, y);

			int time = getTotalTime();
			String timeStr = class_3544.method_15439(time);
			mc.field_1772.method_1720(ms, timeStr, x + 20, y, getColor());

			String status = "";
			if (lock) {
				status = "locked";
			}
			if (!move) {
				status = status.isEmpty() ? "stopped" : "lockedStopped";
			}
			if (!status.isEmpty()) {
				mc.field_1772.method_1720(ms, class_1074.method_4662("botaniamisc." + status), x + 20, y + 12, getColor());
			}
		}

	}

}
