/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import vazkii.botania.api.capability.FloatingFlowerImpl;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.item.IFloatingFlowerProvider;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.decor.BlockFloatingFlower;

public class TileFloatingFlower extends TileMod implements IFloatingFlowerProvider, RenderAttachmentBlockEntity {
	private static final String TAG_FLOATING_DATA = "floating";
	private final IFloatingFlower floatingData = new FloatingFlowerImpl() {
		@Override
		public class_1799 getDisplayStack() {
			class_2248 b = method_11010().method_26204();
			if (b instanceof BlockFloatingFlower) {
				return new class_1799(ModBlocks.getShinyFlower(((BlockFloatingFlower) b).color));
			} else {
				return class_1799.field_8037;
			}
		}
	};

	public TileFloatingFlower() {
		super(ModTiles.MINI_ISLAND);
	}

	@Override
	public IFloatingFlower getFloatingData() {
		return floatingData;
	}

	@Override
	public void fromClientTag(class_2487 tag) {
		IFloatingFlower.IslandType oldType = floatingData.getIslandType();
		super.fromClientTag(tag);
		if (oldType != floatingData.getIslandType()) {
			field_11863.method_8413(method_11016(), method_11010(), method_11010(), 0);
		}
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10566(TAG_FLOATING_DATA, floatingData.writeNBT());
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		floatingData.readNBT(cmp.method_10562(TAG_FLOATING_DATA));
	}

	@Override
	public Object getRenderAttachmentData() {
		return floatingData;
	}
}
