/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import vazkii.botania.common.block.subtile.functional.SubTileBubbell;

import javax.annotation.Nonnull;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class TileFakeAir extends TileMod {
	private static final String TAG_FLOWER_X = "flowerX";
	private static final String TAG_FLOWER_Y = "flowerY";
	private static final String TAG_FLOWER_Z = "flowerZ";

	private class_2338 flowerPos = class_2338.field_10980;

	public TileFakeAir() {
		super(ModTiles.FAKE_AIR);
	}

	public void setFlower(class_2586 tile) {
		flowerPos = tile.method_11016();
		method_5431();
	}

	public boolean canStay() {
		return SubTileBubbell.isValidBubbell(field_11863, flowerPos);
	}

	@Nonnull
	@Override
	public class_2487 method_11007(class_2487 tag) {
		class_2487 ret = super.method_11007(tag);
		ret.method_10569(TAG_FLOWER_X, flowerPos.method_10263());
		ret.method_10569(TAG_FLOWER_Y, flowerPos.method_10264());
		ret.method_10569(TAG_FLOWER_Z, flowerPos.method_10260());
		return ret;
	}

	@Override
	public void method_11014(class_2680 state, class_2487 tag) {
		super.method_11014(state, tag);
		flowerPos = new class_2338(
				tag.method_10550(TAG_FLOWER_X),
				tag.method_10550(TAG_FLOWER_Y),
				tag.method_10550(TAG_FLOWER_Z)
		);
	}

}
