/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import vazkii.botania.common.item.equipment.tool.ToolCommons;

import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2741;
import net.minecraft.class_3000;
import net.minecraft.class_3965;

public class TileEnderEye extends TileMod implements class_3000 {
	public TileEnderEye() {
		super(ModTiles.ENDER_EYE);
	}

	@Override
	public void method_16896() {
		if (field_11863.field_9236) {
			return;
		}

		boolean wasLooking = method_11010().method_11654(class_2741.field_12484);
		int range = 80;
		List<class_1657> players = field_11863.method_18467(class_1657.class, new class_238(field_11867.method_10069(-range, -range, -range), field_11867.method_10069(range, range, range)));

		boolean looking = false;
		for (class_1657 player : players) {
			class_1799 helm = player.method_6118(class_1304.field_6169);
			if (!helm.method_7960() && helm.method_7909() == class_2246.field_10261.method_8389()) {
				continue;
			}

			class_3965 hit = ToolCommons.raytraceFromEntity(player, 64, false);
			if (hit.method_17783() == class_239.class_240.field_1332 && hit.method_17777().equals(method_11016())) {
				looking = true;
				break;
			}
		}

		if (looking != wasLooking) {
			field_11863.method_8501(method_11016(), method_11010().method_11657(class_2741.field_12484, looking));
		}
	}

}
