/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nonnull;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import java.util.List;
import java.util.Optional;

public class TileCraftCrate extends TileOpenCrate {
	private static final String TAG_CRAFTING_RESULT = "craft_result";
	private int signal = 0;
	private class_1799 craftResult = class_1799.field_8037;

	public TileCraftCrate() {
		super(ModTiles.CRAFT_CRATE);
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(9) {
			@Override
			public int method_5444() {
				return 1;
			}

			@Override
			public boolean method_5437(int slot, class_1799 stack) {
				return !isLocked(slot);
			}
		};
	}

	public CratePattern getPattern() {
		class_2680 state = method_11010();
		if (state.method_26204() != ModBlocks.craftCrate) {
			return CratePattern.NONE;
		}
		return state.method_11654(BotaniaStateProps.CRATE_PATTERN);
	}

	private boolean isLocked(int slot) {
		return !getPattern().openSlots.get(slot);
	}

	@Override
	public void readPacketNBT(class_2487 tag) {
		super.readPacketNBT(tag);
		craftResult = class_1799.method_7915(tag.method_10562(TAG_CRAFTING_RESULT));
	}

	@Override
	public void writePacketNBT(class_2487 tag) {
		super.writePacketNBT(tag);
		tag.method_10566(TAG_CRAFTING_RESULT, craftResult.method_7953(new class_2487()));
	}

	@Override
	public void method_16896() {
		if (field_11863.field_9236) {
			return;
		}

		if (canEject() && isFull() && craft(true)) {
			ejectAll();
		}

		int newSignal = 0;
		for (; newSignal < 9; newSignal++) // dis for loop be derpy
		{
			if (!isLocked(newSignal) && getItemHandler().method_5438(newSignal).method_7960()) {
				break;
			}
		}

		if (newSignal != signal) {
			signal = newSignal;
			field_11863.method_8455(field_11867, method_11010().method_26204());
		}
	}

	private boolean craft(boolean fullCheck) {
		if (fullCheck && !isFull()) {
			return false;
		}

		class_1715 craft = new class_1715(new class_1703(class_3917.field_17333, -1) {
			@Override
			public boolean method_7597(@Nonnull class_1657 player) {
				return false;
			}
		}, 3, 3);
		for (int i = 0; i < craft.method_5439(); i++) {
			class_1799 stack = getItemHandler().method_5438(i);

			if (stack.method_7960() || isLocked(i) || stack.method_7909() == ModItems.placeholder) {
				continue;
			}

			craft.method_5447(i, stack);
		}

		Optional<class_3955> matchingRecipe = field_11863.method_8433().method_8132(class_3956.field_17545, craft, field_11863);
		matchingRecipe.ifPresent(recipe -> {
			craftResult = recipe.method_8116(craft);

			List<class_1799> remainders = recipe.method_8111(craft);
			for (int i = 0; i < craft.method_5439(); i++) {
				class_1799 s = remainders.get(i);
				if (!getItemHandler().method_5438(i).method_7960()
						&& getItemHandler().method_5438(i).method_7909() == ModItems.placeholder) {
					continue;
				}
				getItemHandler().method_5447(i, s);
			}
		});

		return matchingRecipe.isPresent();
	}

	boolean isFull() {
		for (int i = 0; i < getItemHandler().method_5439(); i++) {
			if (!isLocked(i) && getItemHandler().method_5438(i).method_7960()) {
				return false;
			}
		}

		return true;
	}

	private void ejectAll() {
		for (int i = 0; i < inventorySize(); ++i) {
			class_1799 stack = getItemHandler().method_5438(i);
			if (!stack.method_7960()) {
				eject(stack, false);
			}
			getItemHandler().method_5447(i, class_1799.field_8037);
		}
		if (!craftResult.method_7960()) {
			eject(craftResult, false);
			craftResult = class_1799.field_8037;
		}
	}

	public boolean onWanded(class_1937 world) {
		if (!world.field_9236 && canEject()) {
			craft(false);
			ejectAll();
		}
		return true;
	}

	@Override
	public void method_5431() {
		super.method_5431();
		if (field_11863 != null && !field_11863.field_9236) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
	}

	public int getSignal() {
		return signal;
	}

}
