/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import vazkii.botania.common.lib.ModTags;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1646;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_3000;
import net.minecraft.class_3494;
import net.minecraft.class_3730;
import net.minecraft.class_3854;
import net.minecraft.class_5425;

public class TileCocoon extends TileMod implements class_3000 {
	private static final String TAG_TIME_PASSED = "timePassed";
	private static final String TAG_EMERALDS_GIVEN = "emeraldsGiven";
	private static final String TAG_CHORUS_FRUIT_GIVEN = "chorusFruitGiven";
	private static final String TAG_GAIA_SPIRIT_GIVEN = "gaiaSpiritGiven";

	public static final int TOTAL_TIME = 2400;
	public static final int MAX_EMERALDS = 20;
	public static final int MAX_CHORUS_FRUITS = 20;
	private static final float SPECIAL_CHANCE = 0.075F;

	public int timePassed;
	public int emeraldsGiven;
	public int chorusFruitGiven;
	public boolean gaiaSpiritGiven;

	public TileCocoon() {
		super(ModTiles.COCOON);
	}

	@Override
	public void method_16896() {
		timePassed++;
		if (timePassed >= TOTAL_TIME) {
			hatch();
		}
	}

	private void hatch() {
		if (!field_11863.field_9236) {
			timePassed = 0;
			field_11863.method_22352(field_11867, false);

			class_1308 entity = null;
			class_2338 placePos = field_11867;
			float rareChance = gaiaSpiritGiven ? 1F : SPECIAL_CHANCE;

			float villagerChance = Math.min(1F, (float) emeraldsGiven / (float) MAX_EMERALDS);
			float shulkerChance = Math.min(1F, (float) chorusFruitGiven / (float) MAX_CHORUS_FRUITS);

			List<class_2338> validWater = new ArrayList<>();
			for (class_2350 d : class_2350.values()) {
				class_2338 blockPos = (d == class_2350.field_11036) ? field_11867 : field_11867.method_10093(d);
				if (field_11863.method_22340(blockPos)
						&& field_11863.method_8320(blockPos).method_26204() == class_2246.field_10382) {
					validWater.add(blockPos);
				}
			}

			if (Math.random() < shulkerChance) {
				entity = class_1299.field_6109.method_5883(field_11863);
			} else if (Math.random() < villagerChance) {
				class_1646 villager = class_1299.field_6077.method_5883(field_11863);
				if (villager != null) {
					class_3854 type = class_3854.method_16930(field_11863.method_31081(field_11867));
					villager.method_7221(villager.method_7231().method_16922(type));
				}
				entity = villager;
			} else if (!validWater.isEmpty()) {
				placePos = validWater.get(field_11863.field_9229.nextInt(validWater.size()));
				if (Math.random() < rareChance) {
					entity = random(ModTags.Entities.COCOON_RARE_AQUATIC);
				} else {
					entity = random(ModTags.Entities.COCOON_COMMON_AQUATIC);
				}
			} else {
				if (Math.random() < rareChance) {
					entity = random(ModTags.Entities.COCOON_RARE);
				} else {
					entity = random(ModTags.Entities.COCOON_COMMON);
				}
			}

			if (entity != null) {
				entity.method_5814(placePos.method_10263() + 0.5, placePos.method_10264() + 0.5, placePos.method_10260() + 0.5);
				if (entity instanceof class_1296) {
					((class_1296) entity).method_5614(-24000);
				}
				entity.method_5943((class_5425) field_11863, field_11863.method_8404(method_11016()), class_3730.field_16467, null, null);
				entity.method_5971();
				field_11863.method_8649(entity);
				entity.method_5990();
			}
		}
	}

	public void forceRare() {
		gaiaSpiritGiven = true;
		timePassed = Math.max(timePassed, TOTAL_TIME / 2);
	}

	private class_1308 random(class_3494<class_1299<?>> tag) {
		class_1299<?> type = tag.method_15142(field_11863.field_9229);
		if (type == class_1299.field_6085 && field_11863.field_9229.nextFloat() < 0.01) {
			type = class_1299.field_6143;
		}
		class_1297 entity = type.method_5883(field_11863);
		return entity instanceof class_1308 ? (class_1308) entity : null;
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10569(TAG_TIME_PASSED, timePassed);
		cmp.method_10569(TAG_EMERALDS_GIVEN, emeraldsGiven);
		cmp.method_10569(TAG_CHORUS_FRUIT_GIVEN, chorusFruitGiven);
		cmp.method_10556(TAG_GAIA_SPIRIT_GIVEN, gaiaSpiritGiven);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		timePassed = cmp.method_10550(TAG_TIME_PASSED);
		emeraldsGiven = cmp.method_10550(TAG_EMERALDS_GIVEN);
		chorusFruitGiven = cmp.method_10550(TAG_CHORUS_FRUIT_GIVEN);
		gaiaSpiritGiven = cmp.method_10577(TAG_GAIA_SPIRIT_GIVEN);
	}
}
