/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import net.minecraft.class_2338;
import net.minecraft.class_2487;
import vazkii.botania.common.block.subtile.generating.SubTileDandelifeon;

public class TileCell extends TileMod {
	private static final String TAG_GENERATION = "generation";
	private static final String TAG_TICKED = "ticked";
	private static final String TAG_FLOWER_X = "flowerX";
	private static final String TAG_FLOWER_Y = "flowerY";
	private static final String TAG_FLOWER_Z = "flowerZ";
	private static final String TAG_VALID_X = "validX";
	private static final String TAG_VALID_Y = "validY";
	private static final String TAG_VALID_Z = "validZ";

	private int generation;
	private boolean ticked;
	private class_2338 flowerCoords = new class_2338(0, -1, 0);
	private class_2338 validCoords = new class_2338(0, -1, 0);

	public TileCell() {
		super(ModTiles.CELL_BLOCK);
	}

	public void setGeneration(SubTileDandelifeon flower, int gen) {
		generation = gen;
		if (!ticked) {
			flowerCoords = flower.getEffectivePos();
			validCoords = method_11016();
			ticked = true;
		} else if (!validCoords.equals(method_11016()) || !flowerCoords.equals(flower.getEffectivePos())) {
			field_11863.method_8650(field_11867, false);
		}
	}

	public boolean isSameFlower(SubTileDandelifeon flower) {
		return validCoords.equals(method_11016()) && flowerCoords.equals(flower.getEffectivePos());
	}

	public int getGeneration() {
		return generation;
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10569(TAG_GENERATION, generation);
		cmp.method_10556(TAG_TICKED, ticked);
		if (ticked) {
			cmp.method_10569(TAG_FLOWER_X, flowerCoords.method_10263());
			cmp.method_10569(TAG_FLOWER_Y, flowerCoords.method_10264());
			cmp.method_10569(TAG_FLOWER_Z, flowerCoords.method_10260());
			cmp.method_10569(TAG_VALID_X, validCoords.method_10263());
			cmp.method_10569(TAG_VALID_Y, validCoords.method_10264());
			cmp.method_10569(TAG_VALID_Z, validCoords.method_10260());
		}
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		generation = cmp.method_10550(TAG_GENERATION);
		ticked = cmp.method_10577(TAG_TICKED);
		if (ticked) {
			flowerCoords = new class_2338(
					cmp.method_10550(TAG_FLOWER_X),
					cmp.method_10550(TAG_FLOWER_Y),
					cmp.method_10550(TAG_FLOWER_Z)
			);
			validCoords = new class_2338(
					cmp.method_10550(TAG_VALID_X),
					cmp.method_10550(TAG_VALID_Y),
					cmp.method_10550(TAG_VALID_Z)
			);
		}
	}

}
