/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.recipe.IBrewRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.crafting.ModRecipeTypes;

import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2741;
import net.minecraft.class_3000;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import java.util.List;
import java.util.Optional;

public class TileBrewery extends TileSimpleInventory implements IManaReceiver, class_3000 {
	private static final String TAG_MANA = "mana";
	private static final int CRAFT_EFFECT_EVENT = 0;

	public IBrewRecipe recipe;
	private int mana = 0;
	private int manaLastTick = 0;
	public int signal = 0;

	public TileBrewery() {
		super(ModTiles.BREWERY);
	}

	public boolean addItem(@Nullable class_1657 player, class_1799 stack, @Nullable class_1268 hand) {
		if (recipe != null || stack.method_7960() || stack.method_7909() instanceof IBrewItem && ((IBrewItem) stack.method_7909()).getBrew(stack) != null && ((IBrewItem) stack.method_7909()).getBrew(stack) != ModBrews.fallbackBrew || getItemHandler().method_5438(0).method_7960() != stack.method_7909() instanceof IBrewContainer) {
			return false;
		}

		boolean did = false;

		for (int i = 0; i < inventorySize(); i++) {
			if (getItemHandler().method_5438(i).method_7960()) {
				did = true;
				class_1799 stackToAdd = stack.method_7972();
				stackToAdd.method_7939(1);
				getItemHandler().method_5447(i, stackToAdd);

				if (player == null || !player.field_7503.field_7477) {
					stack.method_7934(1);
					if (stack.method_7960() && player != null) {
						player.method_6122(hand, class_1799.field_8037);
					}
				}

				break;
			}
		}

		if (did) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
			findRecipe();
		}

		return true;
	}

	private void findRecipe() {
		Optional<IBrewRecipe> maybeRecipe = field_11863.method_8433().method_8132(ModRecipeTypes.BREW_TYPE, getItemHandler(), field_11863);
		maybeRecipe.ifPresent(recipeBrew -> {
			this.recipe = recipeBrew;
			field_11863.method_8501(field_11867, ModBlocks.brewery.method_9564().method_11657(class_2741.field_12484, true));
		});
	}

	@Override
	public void method_16896() {
		if (mana > 0 && recipe == null) {
			findRecipe();

			if (recipe == null) {
				mana = 0;
			}
		}

		// Update every tick.
		receiveMana(0);

		if (!field_11863.field_9236 && recipe == null) {
			List<class_1542> items = field_11863.method_18467(class_1542.class, new class_238(field_11867.method_10263(), field_11867.method_10264(), field_11867.method_10260(), field_11867.method_10263() + 1, field_11867.method_10264() + 1, field_11867.method_10260() + 1));
			for (class_1542 item : items) {
				if (item.method_5805() && !item.method_6983().method_7960()) {
					class_1799 stack = item.method_6983();
					addItem(null, stack, null);
				}
			}
		}

		if (recipe != null) {
			if (!recipe.method_8115(getItemHandler(), field_11863)) {
				recipe = null;
				field_11863.method_8501(field_11867, ModBlocks.brewery.method_9564());
			}

			if (recipe != null) {
				if (mana != manaLastTick) {
					int color = recipe.getBrew().getColor(getItemHandler().method_5438(0));
					float r = (color >> 16 & 0xFF) / 255F;
					float g = (color >> 8 & 0xFF) / 255F;
					float b = (color & 0xFF) / 255F;
					for (int i = 0; i < 5; i++) {
						WispParticleData data1 = WispParticleData.wisp(0.1F + (float) Math.random() * 0.05F, r, g, b);
						field_11863.method_8406(data1, field_11867.method_10263() + 0.7 - Math.random() * 0.4, field_11867.method_10264() + 0.9 - Math.random() * 0.2, field_11867.method_10260() + 0.7 - Math.random() * 0.4, 0.03F - (float) Math.random() * 0.06F, 0.03F + (float) Math.random() * 0.015F, 0.03F - (float) Math.random() * 0.06F);
						for (int j = 0; j < 2; j++) {
							WispParticleData data = WispParticleData.wisp(0.1F + (float) Math.random() * 0.2F, 0.2F, 0.2F, 0.2F);
							field_11863.method_8406(data, field_11867.method_10263() + 0.7 - Math.random() * 0.4, field_11867.method_10264() + 0.9 - Math.random() * 0.2, field_11867.method_10260() + 0.7 - Math.random() * 0.4, 0.03F - (float) Math.random() * 0.06F, 0.03F + (float) Math.random() * 0.015F, 0.03F - (float) Math.random() * 0.06F);
						}
					}
				}

				if (mana >= getManaCost() && !field_11863.field_9236) {
					int mana = getManaCost();
					receiveMana(-mana);

					class_1799 output = recipe.getOutput(getItemHandler().method_5438(0));
					class_1542 outputItem = new class_1542(field_11863, field_11867.method_10263() + 0.5, field_11867.method_10264() + 1.5, field_11867.method_10260() + 0.5, output);
					field_11863.method_8649(outputItem);
					field_11863.method_8427(method_11016(), ModBlocks.brewery, CRAFT_EFFECT_EVENT, recipe.getBrew().getColor(output));

					for (int i = 0; i < inventorySize(); i++) {
						getItemHandler().method_5447(i, class_1799.field_8037);
					}
				}
			}
		}

		int newSignal = 0;
		if (recipe != null) {
			newSignal++;
		}

		if (newSignal != signal) {
			signal = newSignal;
			field_11863.method_8455(field_11867, method_11010().method_26204());
		}

		manaLastTick = mana;
	}

	@Override
	public boolean method_11004(int event, int param) {
		if (event == CRAFT_EFFECT_EVENT) {
			if (field_11863.field_9236) {
				for (int i = 0; i < 25; i++) {
					float r = (param >> 16 & 0xFF) / 255F;
					float g = (param >> 8 & 0xFF) / 255F;
					float b = (param & 0xFF) / 255F;
					SparkleParticleData data1 = SparkleParticleData.sparkle((float) Math.random() * 2F + 0.5F, r, g, b, 10);
					field_11863.method_8406(data1, field_11867.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, field_11867.method_10264() + 1, field_11867.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0, 0, 0);
					for (int j = 0; j < 2; j++) {
						WispParticleData data = WispParticleData.wisp(0.1F + (float) Math.random() * 0.2F, 0.2F, 0.2F, 0.2F);
						field_11863.method_8406(data, field_11867.method_10263() + 0.7 - Math.random() * 0.4, field_11867.method_10264() + 0.9 - Math.random() * 0.2, field_11867.method_10260() + 0.7 - Math.random() * 0.4, 0.05F - (float) Math.random() * 0.1F, 0.05F + (float) Math.random() * 0.03F, 0.05F - (float) Math.random() * 0.1F);
					}
				}
				field_11863.method_8486(field_11867.method_10263(), field_11867.method_10264(), field_11867.method_10260(), ModSounds.potionCreate, class_3419.field_15245, 1F, 1.5F + (float) Math.random() * 0.25F, false);
			}
			return true;
		} else {
			return super.method_11004(event, param);
		}
	}

	public int getManaCost() {
		class_1799 stack = getItemHandler().method_5438(0);
		if (recipe == null || stack.method_7960() || !(stack.method_7909() instanceof IBrewContainer)) {
			return 0;
		}
		IBrewContainer container = (IBrewContainer) stack.method_7909();
		return container.getManaCost(recipe.getBrew(), stack);
	}

	@Override
	public void writePacketNBT(class_2487 tag) {
		super.writePacketNBT(tag);

		tag.method_10569(TAG_MANA, mana);
	}

	@Override
	public void readPacketNBT(class_2487 tag) {
		super.readPacketNBT(tag);

		mana = tag.method_10550(TAG_MANA);
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(7) {
			@Override
			public int method_5444() {
				return 1;
			}
		};
	}

	@Override
	public int getCurrentMana() {
		return mana;
	}

	@Override
	public boolean isFull() {
		return mana >= getManaCost();
	}

	@Override
	public void receiveMana(int mana) {
		this.mana = Math.min(this.mana + mana, getManaCost());
	}

	@Override
	public boolean canReceiveManaFromBursts() {
		return !isFull();
	}

	public void renderHUD(class_4587 ms, class_310 mc) {
		int manaToGet = getManaCost();
		if (manaToGet > 0) {
			int x = mc.method_22683().method_4486() / 2 + 20;
			int y = mc.method_22683().method_4502() / 2 - 8;

			if (recipe == null) {
				return;
			}

			RenderHelper.renderProgressPie(ms, x, y, (float) mana / (float) manaToGet, recipe.getOutput(getItemHandler().method_5438(0)));
		}
	}

}
