/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2741;
import net.minecraft.class_3000;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;

public class TileAvatar extends TileSimpleInventory implements IAvatarTile, class_3000 {
	private static final int MAX_MANA = 6400;

	private static final String TAG_ENABLED = "enabled";
	private static final String TAG_TICKS_ELAPSED = "ticksElapsed";
	private static final String TAG_MANA = "mana";

	private boolean enabled;
	private int ticksElapsed;
	private int mana;

	public TileAvatar() {
		super(ModTiles.AVATAR);
	}

	@Override
	public void method_16896() {
		enabled = true;
		for (class_2350 dir : class_2350.values()) {
			int redstoneSide = field_11863.method_8499(field_11867.method_10093(dir), dir);
			if (redstoneSide > 0) {
				enabled = false;
				break;
			}
		}

		class_1799 stack = getItemHandler().method_5438(0);
		if (!stack.method_7960() && stack.method_7909() instanceof IAvatarWieldable) {
			IAvatarWieldable wieldable = (IAvatarWieldable) stack.method_7909();
			wieldable.onAvatarUpdate(this, stack);
		}

		if (enabled) {
			ticksElapsed++;
		}
	}

	@Override
	public void writePacketNBT(class_2487 tag) {
		super.writePacketNBT(tag);
		tag.method_10556(TAG_ENABLED, enabled);
		tag.method_10569(TAG_TICKS_ELAPSED, ticksElapsed);
		tag.method_10569(TAG_MANA, mana);
	}

	@Override
	public void readPacketNBT(class_2487 tag) {
		super.readPacketNBT(tag);
		enabled = tag.method_10577(TAG_ENABLED);
		ticksElapsed = tag.method_10550(TAG_TICKS_ELAPSED);
		mana = tag.method_10550(TAG_MANA);
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(1) {
			@Override
			public int method_5444() {
				return 1;
			}
		};
	}

	@Override
	public boolean isFull() {
		return mana >= MAX_MANA;
	}

	@Override
	public void receiveMana(int mana) {
		this.mana = Math.min(3 * MAX_MANA, this.mana + mana);
	}

	@Override
	public boolean canReceiveManaFromBursts() {
		return !getItemHandler().method_5438(0).method_7960();
	}

	@Override
	public int getCurrentMana() {
		return mana;
	}

	@Override
	public class_1263 getInventory() {
		return getItemHandler();
	}

	@Override
	public class_2350 getAvatarFacing() {
		return method_11010().method_11654(class_2741.field_12481);
	}

	@Override
	public int getElapsedFunctionalTicks() {
		return ticksElapsed;
	}

	@Override
	public boolean isEnabled() {
		return enabled;
	}

}
