/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import com.mojang.blaze3d.systems.RenderSystem;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1785;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3000;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IPetalApothecary;
import vazkii.botania.api.recipe.ICustomApothecaryColor;
import vazkii.botania.api.recipe.IPetalRecipe;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BlockAltar;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.components.EntityComponents;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.mixin.AccessorBucketItem;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

import alexiil.mc.lib.attributes.ItemAttributeList;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import alexiil.mc.lib.attributes.fluid.FluidExtractable;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.ExactFluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.Ref;
import alexiil.mc.lib.attributes.misc.Reference;

public class TileAltar extends TileSimpleInventory implements IPetalApothecary, class_3000 {

	private static final Pattern SEED_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)seed)|(?:(?:[a-z-_.:]|^)Seed))(?:[sA-Z-_.:]|$)");
	private static final int SET_KEEP_TICKS_EVENT = 0;
	private static final int CRAFT_EFFECT_EVENT = 1;

	public static final String ITEM_TAG_APOTHECARY_SPAWNED = "ApothecarySpawned";

	private List<class_1799> lastRecipe = null;
	private int recipeKeepTicks = 0;

	public TileAltar() {
		super(ModTiles.ALTAR);
	}

	public boolean collideEntityItem(class_1542 item) {
		class_1799 stack = item.method_6983();
		if (field_11863.field_9236 || stack.method_7960() || !item.method_5805()) {
			return false;
		}

		if (method_11010().method_26204() == ModBlocks.defaultAltar && stack.method_7909() == class_2246.field_10597.method_8389()) {
			class_2487 tmp = new class_2487();
			writePacketNBT(tmp);

			stack.method_7934(1);
			field_11863.method_8501(method_11016(), ModBlocks.mossyAltar.method_9564());

			class_2586 newAltar = field_11863.method_8321(method_11016());
			if (newAltar instanceof TileAltar) {
				((TileAltar) newAltar).readPacketNBT(tmp);
			}

			return true;
		}

		boolean hasFluidCapability = FluidAttributes.EXTRACTABLE.getAll(stack).getCount() > 0;

		if (getFluid() == State.EMPTY) {
			// XXX: special handling for now since fish buckets don't have fluid cap, may need to be changed later
			// todo fabric: check if LBA gives fish buckets this
			if (stack.method_7909() instanceof class_1785 && ((AccessorBucketItem) stack.method_7909()).getFluid() == class_3612.field_15910) {
				setFluid(State.WATER);
				((class_1785) stack.method_7909()).method_7728(field_11863, stack, method_11016().method_10084()); // Spawns the fish
				item.method_6979(new class_1799(class_1802.field_8550));
				return true;
			}

			Reference<class_1799> ref = new Ref<>(stack);
			ItemAttributeList<FluidExtractable> extrs = FluidAttributes.EXTRACTABLE.getAll(ref);

			for (int i = 0; i < extrs.getCount(); i++) {
				FluidExtractable extr = extrs.get(i);

				ExactFluidFilter waterFilt = new ExactFluidFilter(FluidKeys.WATER);
				FluidVolume waterExtracted = extr.attemptExtraction(waterFilt, FluidAmount.BUCKET, Simulation.SIMULATE);
				if (waterExtracted.getAmount_F().equals(FluidAmount.BUCKET)) {
					extr.attemptExtraction(waterFilt, FluidAmount.BUCKET, Simulation.ACTION);
					setFluid(State.WATER);
					item.method_6979(ref.get());
					return true;
				}

				ExactFluidFilter lavaFilt = new ExactFluidFilter(FluidKeys.LAVA);
				FluidVolume lavaExtracted = extr.attemptExtraction(lavaFilt, FluidAmount.BUCKET, Simulation.SIMULATE);
				if (lavaExtracted.getAmount_F().equals(FluidAmount.BUCKET)) {
					extr.attemptExtraction(lavaFilt, FluidAmount.BUCKET, Simulation.ACTION);
					setFluid(State.LAVA);
					item.method_6979(ref.get());
					return true;
				}

			}

			return false;
		}

		if (getFluid() == State.LAVA) {
			item.method_5639(100);
			return true;
		}

		if (SEED_PATTERN.matcher(stack.method_7922()).find()) {
			Optional<IPetalRecipe> maybeRecipe = field_11863.method_8433().method_8132(ModRecipeTypes.PETAL_TYPE, getItemHandler(), field_11863);
			maybeRecipe.ifPresent(recipe -> {
				saveLastRecipe();
				class_1799 output = recipe.method_8116(getItemHandler());

				for (int i = 0; i < inventorySize(); i++) {
					getItemHandler().method_5447(i, class_1799.field_8037);
				}

				stack.method_7934(1);

				class_1542 outputItem = new class_1542(field_11863, field_11867.method_10263() + 0.5, field_11867.method_10264() + 1.5, field_11867.method_10260() + 0.5, output);
				EntityComponents.INTERNAL_ITEM.get(outputItem).apothecarySpawned = true;
				field_11863.method_8649(outputItem);

				setFluid(State.EMPTY);

				field_11863.method_8427(method_11016(), method_11010().method_26204(), CRAFT_EFFECT_EVENT, 0);
			});
			return maybeRecipe.isPresent();
		} else if (!hasFluidCapability && !EntityComponents.INTERNAL_ITEM.get(item).apothecarySpawned) {
			if (!getItemHandler().method_5438(inventorySize() - 1).method_7960()) {
				return false;
			}

			for (int i = 0; i < inventorySize(); i++) {
				if (getItemHandler().method_5438(i).method_7960()) {
					getItemHandler().method_5447(i, stack.method_7971(1));
					field_11863.method_8396(null, field_11867, class_3417.field_14737, class_3419.field_15245, 0.1F, 10F);
					return true;
				}
			}
		}

		return false;
	}

	@Nullable
	private ICustomApothecaryColor getFlowerComponent(class_1799 stack) {
		ICustomApothecaryColor c = null;
		if (stack.method_7909() instanceof ICustomApothecaryColor) {
			c = (ICustomApothecaryColor) stack.method_7909();
		}
		return c;
	}

	public void saveLastRecipe() {
		lastRecipe = new ArrayList<>();
		for (int i = 0; i < inventorySize(); i++) {
			class_1799 stack = getItemHandler().method_5438(i);
			if (stack.method_7960()) {
				break;
			}
			lastRecipe.add(stack.method_7972());
		}
		recipeKeepTicks = 400;
		field_11863.method_8427(method_11016(), method_11010().method_26204(), SET_KEEP_TICKS_EVENT, 400);
	}

	public void trySetLastRecipe(class_1657 player) {
		tryToSetLastRecipe(player, getItemHandler(), lastRecipe);
		if (!isEmpty()) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
	}

	public static void tryToSetLastRecipe(class_1657 player, class_1263 inv, List<class_1799> lastRecipe) {
		if (lastRecipe == null || lastRecipe.isEmpty() || player.field_6002.field_9236) {
			return;
		}

		int index = 0;
		boolean didAny = false;
		for (class_1799 stack : lastRecipe) {
			if (stack.method_7960()) {
				continue;
			}

			for (int i = 0; i < player.field_7514.method_5439(); i++) {
				class_1799 pstack = player.field_7514.method_5438(i);
				if (player.method_7337() || (!pstack.method_7960() && pstack.method_7962(stack) && class_1799.method_7975(stack, pstack))) {
					inv.method_5447(index, player.method_7337() ? stack.method_7972() : pstack.method_7971(1));
					didAny = true;
					index++;
					break;
				}
			}
		}

		if (didAny) {
			player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14737, class_3419.field_15245, 0.1F, 10F);
			class_3222 mp = (class_3222) player;
			mp.field_7498.method_7623();
		}
	}

	public boolean isEmpty() {
		for (int i = 0; i < inventorySize(); i++) {
			if (!getItemHandler().method_5438(i).method_7960()) {
				return false;
			}
		}

		return true;
	}

	@Override
	public void method_16896() {
		if (!field_11863.field_9236) {
			List<class_1542> items = field_11863.method_18467(class_1542.class, new class_238(field_11867.method_10080(0, 1D / 16D * 20D, 0), field_11867.method_10080(1, 1D / 16D * 32D, 1)));

			boolean didChange = false;
			for (class_1542 item : items) {
				didChange = collideEntityItem(item) || didChange;
			}

			if (didChange) {
				VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
			}
		} else {
			for (int i = 0; i < inventorySize(); i++) {
				class_1799 stackAt = getItemHandler().method_5438(i);
				if (stackAt.method_7960()) {
					break;
				}

				if (Math.random() >= 0.97) {
					ICustomApothecaryColor comp = getFlowerComponent(stackAt);

					int color = comp == null ? 0x888888 : comp.getParticleColor(stackAt);
					float red = (color >> 16 & 0xFF) / 255F;
					float green = (color >> 8 & 0xFF) / 255F;
					float blue = (color & 0xFF) / 255F;
					if (Math.random() >= 0.75F) {
						field_11863.method_8396(null, field_11867, class_3417.field_14737, class_3419.field_15245, 0.1F, 10F);
					}
					SparkleParticleData data = SparkleParticleData.sparkle((float) Math.random(), red, green, blue, 10);
					field_11863.method_8406(data, field_11867.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, field_11867.method_10264() + 1.2, field_11867.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0, 0, 0);
				}
			}

			if (getFluid() == State.LAVA) {
				field_11863.method_8406(class_2398.field_11251, field_11867.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, field_11867.method_10264() + 1, field_11867.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0, 0.05, 0);
				if (Math.random() > 0.9) {
					field_11863.method_8406(class_2398.field_11239, field_11867.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, field_11867.method_10264() + 1, field_11867.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0, 0.01, 0);
				}
			}
		}

		if (recipeKeepTicks > 0) {
			--recipeKeepTicks;
		} else {
			lastRecipe = null;
		}
	}

	@Override
	public boolean method_11004(int id, int param) {
		switch (id) {
		case SET_KEEP_TICKS_EVENT:
			recipeKeepTicks = param;
			return true;
		case CRAFT_EFFECT_EVENT: {
			if (field_11863.field_9236) {
				for (int i = 0; i < 25; i++) {
					float red = (float) Math.random();
					float green = (float) Math.random();
					float blue = (float) Math.random();
					SparkleParticleData data = SparkleParticleData.sparkle((float) Math.random(), red, green, blue, 10);
					field_11863.method_8406(data, field_11867.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, field_11867.method_10264() + 1, field_11867.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0, 0, 0);
				}
				field_11863.method_8486(field_11867.method_10263(), field_11867.method_10264(), field_11867.method_10260(), ModSounds.altarCraft, class_3419.field_15245, 1F, 1F, false);
			}
			return true;
		}
		default:
			return super.method_11004(id, param);
		}
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(16) {
			@Override
			public int method_5444() {
				return 1;
			}
		};
	}

	@Override
	public void setFluid(State fluid) {
		field_11863.method_8501(method_11016(), method_11010().method_11657(BlockAltar.FLUID, fluid));
	}

	@Override
	public State getFluid() {
		return method_11010().method_11654(BlockAltar.FLUID);
	}

	@Environment(EnvType.CLIENT)
	public void renderHUD(class_4587 ms, class_310 mc) {
		int xc = mc.method_22683().method_4486() / 2;
		int yc = mc.method_22683().method_4502() / 2;

		float angle = -90;
		int radius = 24;
		int amt = 0;
		for (int i = 0; i < inventorySize(); i++) {
			if (getItemHandler().method_5438(i).method_7960()) {
				break;
			}
			amt++;
		}

		if (amt > 0) {
			float anglePer = 360F / amt;

			Optional<IPetalRecipe> maybeRecipe = field_11863.method_8433().method_8132(ModRecipeTypes.PETAL_TYPE, getItemHandler(), field_11863);
			maybeRecipe.ifPresent(recipe -> {
				RenderSystem.color4f(1F, 1F, 1F, 1F);
				mc.method_1531().method_22813(HUDHandler.manaBar);
				RenderHelper.drawTexturedModalRect(ms, xc + radius + 9, yc - 8, 0, 8, 22, 15);

				class_1799 stack = recipe.method_8116(getItemHandler());

				mc.method_1480().method_4010(stack, xc + radius + 32, yc - 8);
				mc.method_1480().method_4010(new class_1799(class_1802.field_8317), xc + radius + 16, yc + 6);
				mc.field_1772.method_1729(ms, "+", xc + radius + 14, yc + 10, 0xFFFFFF);
			});

			for (int i = 0; i < amt; i++) {
				double xPos = xc + Math.cos(angle * Math.PI / 180D) * radius - 8;
				double yPos = yc + Math.sin(angle * Math.PI / 180D) * radius - 8;
				RenderSystem.translated(xPos, yPos, 0);
				mc.method_1480().method_4010(getItemHandler().method_5438(i), 0, 0);
				RenderSystem.translated(-xPos, -yPos, 0);

				angle += anglePer;
			}
		} else if (recipeKeepTicks > 0 && getFluid() == State.WATER) {
			String s = class_1074.method_4662("botaniamisc.altarRefill0");
			mc.field_1772.method_1729(ms, s, xc - mc.field_1772.method_1727(s) / 2, yc + 10, 0xFFFFFF);
			s = class_1074.method_4662("botaniamisc.altarRefill1");
			mc.field_1772.method_1729(ms, s, xc - mc.field_1772.method_1727(s) / 2, yc + 20, 0xFFFFFF);
		}
	}

}
