/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import vazkii.botania.api.recipe.ElvenPortalUpdateCallback;
import vazkii.botania.api.recipe.IElvenItem;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.advancements.AlfPortalBreadTrigger;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.components.EntityComponents;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3000;
import net.minecraft.class_3222;
import net.minecraft.class_3528;
import java.util.*;
import java.util.stream.Collectors;

public class TileAlfPortal extends TileMod implements class_3000 {
	public static final class_3528<IMultiblock> MULTIBLOCK = new class_3528<>(() -> PatchouliAPI.get().makeMultiblock(
			new String[][] {
					{ "_", "W", "G", "W", "_" },
					{ "W", " ", " ", " ", "W" },
					{ "G", " ", " ", " ", "G" },
					{ "W", " ", " ", " ", "W" },
					{ "_", "W", "0", "W", "_" }
			},
			'W', ModBlocks.livingwood,
			'G', ModBlocks.livingwoodGlimmering,
			'0', ModBlocks.alfPortal
	));

	private static final String TAG_TICKS_OPEN = "ticksOpen";
	private static final String TAG_TICKS_SINCE_LAST_ITEM = "ticksSinceLastItem";
	private static final String TAG_STACK_COUNT = "stackCount";
	private static final String TAG_STACK = "portalStack";
	public static final String TAG_PORTAL_FLAG = "_elvenPortal";

	private final List<class_1799> stacksIn = new ArrayList<>();

	public int ticksOpen = 0;
	private int ticksSinceLastItem = 0;
	private boolean closeNow = false;
	private boolean explode = false;
	@Nullable
	private UUID breadPlayer = null;

	public TileAlfPortal() {
		super(ModTiles.ALF_PORTAL);
	}

	@Override
	public void method_16896() {
		if (method_11010().method_11654(BotaniaStateProps.ALFPORTAL_STATE) == AlfPortalState.OFF) {
			ticksOpen = 0;
			return;
		}
		AlfPortalState state = method_11010().method_11654(BotaniaStateProps.ALFPORTAL_STATE);
		AlfPortalState newState = getValidState();

		ticksOpen++;

		class_238 aabb = getPortalAABB();
		boolean open = ticksOpen > 60;
		ElvenPortalUpdateCallback.EVENT.invoker().onElvenPortalTick(this, aabb, open, stacksIn);

		if (ticksOpen > 60) {
			ticksSinceLastItem++;
			if (field_11863.field_9236 && ConfigHandler.CLIENT.elfPortalParticlesEnabled.getValue()) {
				blockParticle(state);
			}

			List<class_1542> items = field_11863.method_18467(class_1542.class, aabb);
			if (!field_11863.field_9236) {
				for (class_1542 item : items) {
					if (!item.method_5805()) {
						continue;
					}

					class_1799 stack = item.method_6983();
					boolean consume;
					if (EntityComponents.INTERNAL_ITEM.get(item).alfPortalSpawned) {
						consume = false;
					} else if (stack.method_7909() instanceof ItemLexicon) {
						consume = true;
					} else if ((!(stack.method_7909() instanceof IElvenItem) || !((IElvenItem) stack.method_7909()).isElvenItem(stack))) {
						consume = true;
					} else {
						consume = false;
					}

					if (consume) {
						item.method_5650();
						if (validateItemUsage(item)) {
							addItem(stack);
						}
						ticksSinceLastItem = 0;
					}
				}
			}

			if (!field_11863.field_9236 && !stacksIn.isEmpty() && ticksSinceLastItem >= 4) {
				resolveRecipes();
			}
		}

		if (closeNow) {
			if (!field_11863.field_9236) {
				field_11863.method_8501(method_11016(), ModBlocks.alfPortal.method_9564());
			}
			for (int i = 0; i < 36; i++) {
				blockParticle(state);
			}
			closeNow = false;
		} else if (newState != state) {
			if (newState == AlfPortalState.OFF) {
				for (int i = 0; i < 36; i++) {
					blockParticle(state);
				}
			}

			if (!field_11863.field_9236) {
				field_11863.method_8501(method_11016(), method_11010().method_11657(BotaniaStateProps.ALFPORTAL_STATE, newState));
			}
		} else if (explode) {
			field_11863.method_8437(null, field_11867.method_10263() + .5, field_11867.method_10264() + 2.0, field_11867.method_10260() + .5,
					3f, class_1927.class_4179.field_18686);
			explode = false;

			if (!field_11863.field_9236 && breadPlayer != null) {
				class_1657 entity = field_11863.method_18470(breadPlayer);
				if (entity instanceof class_3222) {
					AlfPortalBreadTrigger.INSTANCE.trigger((class_3222) entity, method_11016());
				}
			}
			breadPlayer = null;
		}
	}

	private boolean validateItemUsage(class_1542 entity) {
		class_1799 inputStack = entity.method_6983();
		for (class_1860<?> recipe : ModRecipeTypes.getRecipes(field_11863, ModRecipeTypes.ELVEN_TRADE_TYPE).values()) {
			if (recipe instanceof IElvenTradeRecipe && ((IElvenTradeRecipe) recipe).containsItem(inputStack)) {
				return true;
			}
		}
		if (inputStack.method_7909() == class_1802.field_8229) {
			//Don't teleport bread. (See also: #2403)
			explode = true;
			breadPlayer = entity.method_6978();
		}

		return false;
	}

	private void blockParticle(AlfPortalState state) {
		double dh, dy;

		// Pick one of the inner positions
		switch (field_11863.field_9229.nextInt(9)) {
		default:
		case 0:
			dh = 0;
			dy = 1;
			break;
		case 1:
			dh = 0;
			dy = 2;
			break;
		case 2:
			dh = 0;
			dy = 3;
			break;
		case 3:
			dh = -1;
			dy = 1;
			break;
		case 4:
			dh = -1;
			dy = 2;
			break;
		case 5:
			dh = -1;
			dy = 3;
			break;
		case 6:
			dh = 1;
			dy = 1;
			break;
		case 7:
			dh = 1;
			dy = 2;
			break;
		case 8:
			dh = 1;
			dy = 3;
			break;
		}
		double dx = state == AlfPortalState.ON_X ? 0 : dh;
		double dz = state == AlfPortalState.ON_Z ? 0 : dh;

		float motionMul = 0.2F;
		WispParticleData data = WispParticleData.wisp((float) (Math.random() * 0.15F + 0.1F), (float) (Math.random() * 0.25F), (float) (Math.random() * 0.5F + 0.5F), (float) (Math.random() * 0.25F));
		field_11863.method_8406(data, method_11016().method_10263() + dx, method_11016().method_10264() + dy, method_11016().method_10260() + dz, (float) (Math.random() - 0.5F) * motionMul, (float) (Math.random() - 0.5F) * motionMul, (float) (Math.random() - 0.5F) * motionMul);
	}

	public boolean onWanded() {
		AlfPortalState state = method_11010().method_11654(BotaniaStateProps.ALFPORTAL_STATE);
		if (state == AlfPortalState.OFF) {
			AlfPortalState newState = getValidState();
			if (newState != AlfPortalState.OFF) {
				field_11863.method_8501(method_11016(), method_11010().method_11657(BotaniaStateProps.ALFPORTAL_STATE, newState));
				return true;
			}
		}

		return false;
	}

	private class_238 getPortalAABB() {
		class_238 aabb = new class_238(field_11867.method_10069(-1, 1, 0), field_11867.method_10069(2, 4, 1));
		if (method_11010().method_11654(BotaniaStateProps.ALFPORTAL_STATE) == AlfPortalState.ON_X) {
			aabb = new class_238(field_11867.method_10069(0, 1, -1), field_11867.method_10069(1, 4, 2));
		}

		return aabb;
	}

	private void addItem(class_1799 stack) {
		int size = stack.method_7947();
		stack.method_7939(1);
		for (int i = 0; i < size; i++) {
			stacksIn.add(stack.method_7972());
		}
	}

	@SuppressWarnings("unchecked")
	public static Collection<IElvenTradeRecipe> elvenTradeRecipes(class_1937 world) {
		// By virtue of IRecipeType's type parameter,
		// we know all the recipes in the map must be IElvenTradeRecipe.
		// However, vanilla's signature on this method is dumb (should be Map<ResourceLocation, T>)
		return (Collection<IElvenTradeRecipe>) (Collection<?>) ModRecipeTypes.getRecipes(world, ModRecipeTypes.ELVEN_TRADE_TYPE).values();
	}

	private void resolveRecipes() {
		List<class_2338> pylons = locatePylons();
		for (class_1860<?> r : ModRecipeTypes.getRecipes(field_11863, ModRecipeTypes.ELVEN_TRADE_TYPE).values()) {
			if (!(r instanceof IElvenTradeRecipe)) {
				continue;
			}
			IElvenTradeRecipe recipe = (IElvenTradeRecipe) r;
			Optional<List<class_1799>> match = recipe.match(stacksIn);
			if (match.isPresent()) {
				if (consumeMana(pylons, 500, false)) {
					List<class_1799> inputs = match.get();
					for (class_1799 stack : inputs) {
						stacksIn.remove(stack);
					}
					for (class_1799 output : recipe.getOutputs(inputs)) {
						spawnItem(output.method_7972());
					}
				}
				break;
			}
		}
	}

	private void spawnItem(class_1799 stack) {
		class_1542 item = new class_1542(field_11863, field_11867.method_10263() + 0.5, field_11867.method_10264() + 1.5, field_11867.method_10260() + 0.5, stack);
		EntityComponents.INTERNAL_ITEM.get(item).alfPortalSpawned = true;
		field_11863.method_8649(item);
		ticksSinceLastItem = 0;
	}

	@Nonnull
	@Override
	public class_2487 method_11007(class_2487 cmp) {
		class_2487 ret = super.method_11007(cmp);

		cmp.method_10569(TAG_STACK_COUNT, stacksIn.size());
		int i = 0;
		for (class_1799 stack : stacksIn) {
			class_2487 stackcmp = stack.method_7953(new class_2487());
			cmp.method_10566(TAG_STACK + i, stackcmp);
			i++;
		}

		return ret;
	}

	@Override
	public void method_11014(class_2680 state, class_2487 cmp) {
		super.method_11014(state, cmp);

		int count = cmp.method_10550(TAG_STACK_COUNT);
		stacksIn.clear();
		for (int i = 0; i < count; i++) {
			class_2487 stackcmp = cmp.method_10562(TAG_STACK + i);
			class_1799 stack = class_1799.method_7915(stackcmp);
			stacksIn.add(stack);
		}
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10569(TAG_TICKS_OPEN, ticksOpen);
		cmp.method_10569(TAG_TICKS_SINCE_LAST_ITEM, ticksSinceLastItem);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		ticksOpen = cmp.method_10550(TAG_TICKS_OPEN);
		ticksSinceLastItem = cmp.method_10550(TAG_TICKS_SINCE_LAST_ITEM);
	}

	private AlfPortalState getValidState() {
		class_2470 rot = MULTIBLOCK.method_15332().validate(field_11863, method_11016());
		if (rot == null) {
			return AlfPortalState.OFF;
		}

		lightPylons();
		switch (rot) {
		default:
		case field_11467:
		case field_11464:
			return AlfPortalState.ON_Z;
		case field_11463:
		case field_11465:
			return AlfPortalState.ON_X;
		}
	}

	public List<class_2338> locatePylons() {
		int range = 5;

		class_2680 pylonState = ModBlocks.naturaPylon.method_9564();

		return class_2338.method_20437(method_11016().method_10069(-range, -range, -range), method_11016().method_10069(range, range, range))
				.filter(field_11863::method_22340)
				.filter(p -> field_11863.method_8320(p) == pylonState && field_11863.method_8320(p.method_10074()).method_26204() instanceof BlockPool)
				.map(class_2338::method_10062)
				.collect(Collectors.toList());
	}

	public void lightPylons() {
		if (ticksOpen < 50) {
			return;
		}

		List<class_2338> pylons = locatePylons();
		for (class_2338 pos : pylons) {
			class_2586 tile = field_11863.method_8321(pos);
			if (tile instanceof TilePylon) {
				TilePylon pylon = (TilePylon) tile;
				pylon.activated = true;
				pylon.centerPos = method_11016();
			}
		}

		if (ticksOpen == 50) {
			consumeMana(pylons, 200000, true);
		}
	}

	public boolean consumeMana(List<class_2338> pylons, int totalCost, boolean close) {
		List<TilePool> consumePools = new ArrayList<>();
		int consumed = 0;

		if (pylons.size() < 2) {
			closeNow = true;
			return false;
		}

		int costPer = Math.max(1, totalCost / pylons.size());
		int expectedConsumption = costPer * pylons.size();

		for (class_2338 pos : pylons) {
			class_2586 tile = field_11863.method_8321(pos);
			if (tile instanceof TilePylon) {
				TilePylon pylon = (TilePylon) tile;
				pylon.activated = true;
				pylon.centerPos = method_11016();
			}

			tile = field_11863.method_8321(pos.method_10074());
			if (tile instanceof TilePool) {
				TilePool pool = (TilePool) tile;

				if (pool.getCurrentMana() < costPer) {
					closeNow = closeNow || close;
					return false;
				} else if (!field_11863.field_9236) {
					consumePools.add(pool);
					consumed += costPer;
				}
			}
		}

		if (consumed >= expectedConsumption) {
			for (TilePool pool : consumePools) {
				pool.receiveMana(-costPer);
			}
			return true;
		}

		return false;
	}
}
