/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.tile;

import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.corporea.*;
import vazkii.botania.common.block.tile.mana.*;
import vazkii.botania.common.block.tile.string.*;
import vazkii.botania.common.lib.LibBlockNames;

import java.util.Arrays;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;

import static vazkii.botania.common.block.ModBlocks.*;

public class ModTiles {
	public static final class_2591<TileAltar> ALTAR = class_2591.class_2592.method_20528(TileAltar::new,
			defaultAltar, forestAltar, plainsAltar, mountainAltar, fungalAltar,
			swampAltar, desertAltar, taigaAltar, mesaAltar, mossyAltar
	).method_11034(null);
	public static final class_2591<TileSpreader> SPREADER = class_2591.class_2592.method_20528(TileSpreader::new, manaSpreader, redstoneSpreader, elvenSpreader, gaiaSpreader).method_11034(null);
	public static final class_2591<TilePool> POOL = class_2591.class_2592.method_20528(TilePool::new, manaPool, dilutedPool, fabulousPool, creativePool).method_11034(null);
	public static final class_2591<TileRuneAltar> RUNE_ALTAR = class_2591.class_2592.method_20528(TileRuneAltar::new, runeAltar).method_11034(null);
	public static final class_2591<TilePylon> PYLON = class_2591.class_2592.method_20528(TilePylon::new, manaPylon, naturaPylon, gaiaPylon).method_11034(null);
	public static final class_2591<TileDistributor> DISTRIBUTOR = class_2591.class_2592.method_20528(TileDistributor::new, distributor).method_11034(null);
	public static final class_2591<TileManaVoid> MANA_VOID = class_2591.class_2592.method_20528(TileManaVoid::new, manaVoid).method_11034(null);
	public static final class_2591<TileManaDetector> MANA_DETECTOR = class_2591.class_2592.method_20528(TileManaDetector::new, manaDetector).method_11034(null);
	public static final class_2591<TileEnchanter> ENCHANTER = class_2591.class_2592.method_20528(TileEnchanter::new, enchanter).method_11034(null);
	public static final class_2591<TileTurntable> TURNTABLE = class_2591.class_2592.method_20528(TileTurntable::new, turntable).method_11034(null);
	public static final class_2591<TileTinyPlanet> TINY_PLANET = class_2591.class_2592.method_20528(TileTinyPlanet::new, tinyPlanet).method_11034(null);
	public static final class_2591<TileOpenCrate> OPEN_CRATE = class_2591.class_2592.method_20528(TileOpenCrate::new, openCrate).method_11034(null);
	public static final class_2591<TileCraftCrate> CRAFT_CRATE = class_2591.class_2592.method_20528(TileCraftCrate::new, craftCrate).method_11034(null);
	public static final class_2591<TileForestEye> FORSET_EYE = class_2591.class_2592.method_20528(TileForestEye::new, forestEye).method_11034(null);
	public static final class_2591<TilePlatform> PLATFORM = class_2591.class_2592.method_20528(TilePlatform::new, abstrusePlatform, spectralPlatform, infrangiblePlatform).method_11034(null);
	public static final class_2591<TileAlfPortal> ALF_PORTAL = class_2591.class_2592.method_20528(TileAlfPortal::new, alfPortal).method_11034(null);
	public static final class_2591<TileBifrost> BIFROST = class_2591.class_2592.method_20528(TileBifrost::new, bifrost).method_11034(null);
	public static final class_2591<TileFloatingFlower> MINI_ISLAND = class_2591.class_2592.method_20528(TileFloatingFlower::new, Arrays.stream(class_1767.values()).map(ModBlocks::getFloatingFlower).toArray(class_2248[]::new)).method_11034(null);
	public static final class_2591<TileTinyPotato> TINY_POTATO = class_2591.class_2592.method_20528(TileTinyPotato::new, tinyPotato).method_11034(null);
	public static final class_2591<TileSpawnerClaw> SPAWNER_CLAW = class_2591.class_2592.method_20528(TileSpawnerClaw::new, spawnerClaw).method_11034(null);
	public static final class_2591<TileEnderEye> ENDER_EYE = class_2591.class_2592.method_20528(TileEnderEye::new, enderEye).method_11034(null);
	public static final class_2591<TileStarfield> STARFIELD = class_2591.class_2592.method_20528(TileStarfield::new, starfield).method_11034(null);
	public static final class_2591<TileRFGenerator> FLUXFIELD = class_2591.class_2592.method_20528(TileRFGenerator::new, rfGenerator).method_11034(null);
	public static final class_2591<TileBrewery> BREWERY = class_2591.class_2592.method_20528(TileBrewery::new, brewery).method_11034(null);
	public static final class_2591<TileTerraPlate> TERRA_PLATE = class_2591.class_2592.method_20528(TileTerraPlate::new, terraPlate).method_11034(null);
	public static final class_2591<TileRedStringContainer> RED_STRING_CONTAINER = class_2591.class_2592.method_20528(TileRedStringContainer::new, redStringContainer).method_11034(null);
	public static final class_2591<TileRedStringDispenser> RED_STRING_DISPENSER = class_2591.class_2592.method_20528(TileRedStringDispenser::new, redStringDispenser).method_11034(null);
	public static final class_2591<TileRedStringFertilizer> RED_STRING_FERTILIZER = class_2591.class_2592.method_20528(TileRedStringFertilizer::new, redStringFertilizer).method_11034(null);
	public static final class_2591<TileRedStringComparator> RED_STRING_COMPARATOR = class_2591.class_2592.method_20528(TileRedStringComparator::new, redStringComparator).method_11034(null);
	public static final class_2591<TileRedStringRelay> RED_STRING_RELAY = class_2591.class_2592.method_20528(TileRedStringRelay::new, redStringRelay).method_11034(null);
	public static final class_2591<TileManaFlame> MANA_FLAME = class_2591.class_2592.method_20528(TileManaFlame::new, manaFlame).method_11034(null);
	public static final class_2591<TilePrism> PRISM = class_2591.class_2592.method_20528(TilePrism::new, prism).method_11034(null);
	public static final class_2591<TileCorporeaIndex> CORPOREA_INDEX = class_2591.class_2592.method_20528(TileCorporeaIndex::new, corporeaIndex).method_11034(null);
	public static final class_2591<TileCorporeaFunnel> CORPOREA_FUNNEL = class_2591.class_2592.method_20528(TileCorporeaFunnel::new, corporeaFunnel).method_11034(null);
	public static final class_2591<TilePump> PUMP = class_2591.class_2592.method_20528(TilePump::new, pump).method_11034(null);
	public static final class_2591<TileFakeAir> FAKE_AIR = class_2591.class_2592.method_20528(TileFakeAir::new, fakeAir).method_11034(null);
	public static final class_2591<TileCorporeaInterceptor> CORPOREA_INTERCEPTOR = class_2591.class_2592.method_20528(TileCorporeaInterceptor::new, corporeaInterceptor).method_11034(null);
	public static final class_2591<TileCorporeaCrystalCube> CORPOREA_CRYSTAL_CUBE = class_2591.class_2592.method_20528(TileCorporeaCrystalCube::new, corporeaCrystalCube).method_11034(null);
	public static final class_2591<TileIncensePlate> INCENSE_PLATE = class_2591.class_2592.method_20528(TileIncensePlate::new, incensePlate).method_11034(null);
	public static final class_2591<TileHourglass> HOURGLASS = class_2591.class_2592.method_20528(TileHourglass::new, hourglass).method_11034(null);
	public static final class_2591<TileSparkChanger> SPARK_CHANGER = class_2591.class_2592.method_20528(TileSparkChanger::new, sparkChanger).method_11034(null);
	public static final class_2591<TileCocoon> COCOON = class_2591.class_2592.method_20528(TileCocoon::new, cocoon).method_11034(null);
	public static final class_2591<TileLightRelay> LIGHT_RELAY = class_2591.class_2592.method_20528(TileLightRelay::new, lightRelayDefault, lightRelayDetector, lightRelayToggle, lightRelayFork).method_11034(null);
	public static final class_2591<TileCacophonium> CACOPHONIUM = class_2591.class_2592.method_20528(TileCacophonium::new, cacophonium).method_11034(null);
	public static final class_2591<TileBellows> BELLOWS = class_2591.class_2592.method_20528(TileBellows::new, bellows).method_11034(null);
	public static final class_2591<TileCell> CELL_BLOCK = class_2591.class_2592.method_20528(TileCell::new, cellBlock).method_11034(null);
	public static final class_2591<TileRedStringInterceptor> RED_STRING_INTERCEPTOR = class_2591.class_2592.method_20528(TileRedStringInterceptor::new, redStringInterceptor).method_11034(null);
	public static final class_2591<TileGaiaHead> GAIA_HEAD = class_2591.class_2592.method_20528(TileGaiaHead::new, gaiaHead, gaiaHeadWall).method_11034(null);
	public static final class_2591<TileCorporeaRetainer> CORPOREA_RETAINER = class_2591.class_2592.method_20528(TileCorporeaRetainer::new, corporeaRetainer).method_11034(null);
	public static final class_2591<TileTeruTeruBozu> TERU_TERU_BOZU = class_2591.class_2592.method_20528(TileTeruTeruBozu::new, teruTeruBozu).method_11034(null);
	public static final class_2591<TileAvatar> AVATAR = class_2591.class_2592.method_20528(TileAvatar::new, avatar).method_11034(null);
	public static final class_2591<TileAnimatedTorch> ANIMATED_TORCH = class_2591.class_2592.method_20528(TileAnimatedTorch::new, animatedTorch).method_11034(null);

	public static void registerTiles() {
		class_2378<class_2591<?>> r = class_2378.field_11137;
		register(r, LibBlockNames.ALTAR, ALTAR);
		register(r, LibBlockNames.SPREADER, SPREADER);
		register(r, LibBlockNames.POOL, POOL);
		register(r, LibBlockNames.RUNE_ALTAR, RUNE_ALTAR);
		register(r, LibBlockNames.PYLON, PYLON);
		register(r, LibBlockNames.DISTRIBUTOR, DISTRIBUTOR);
		register(r, LibBlockNames.MANA_VOID, MANA_VOID);
		register(r, LibBlockNames.MANA_DETECTOR, MANA_DETECTOR);
		register(r, LibBlockNames.ENCHANTER, ENCHANTER);
		register(r, LibBlockNames.TURNTABLE, TURNTABLE);
		register(r, LibBlockNames.TINY_PLANET, TINY_PLANET);
		register(r, LibBlockNames.OPEN_CRATE, OPEN_CRATE);
		register(r, LibBlockNames.CRAFT_CRATE, CRAFT_CRATE);
		register(r, LibBlockNames.FOREST_EYE, FORSET_EYE);
		register(r, LibBlockNames.PLATFORM, PLATFORM);
		register(r, LibBlockNames.ALF_PORTAL, ALF_PORTAL);
		register(r, LibBlockNames.BIFROST, BIFROST);
		register(r, LibBlockNames.MINI_ISLAND, MINI_ISLAND);
		register(r, LibBlockNames.TINY_POTATO, TINY_POTATO);
		register(r, LibBlockNames.SPAWNER_CLAW, SPAWNER_CLAW);
		register(r, LibBlockNames.ENDER_EYE_BLOCK, ENDER_EYE);
		register(r, LibBlockNames.STARFIELD, STARFIELD);
		register(r, LibBlockNames.FLUXFIELD, FLUXFIELD);
		register(r, LibBlockNames.BREWERY, BREWERY);
		register(r, LibBlockNames.TERRA_PLATE, TERRA_PLATE);
		register(r, LibBlockNames.RED_STRING_CONTAINER, RED_STRING_CONTAINER);
		register(r, LibBlockNames.RED_STRING_DISPENSER, RED_STRING_DISPENSER);
		register(r, LibBlockNames.RED_STRING_FERTILIZER, RED_STRING_FERTILIZER);
		register(r, LibBlockNames.RED_STRING_COMPARATOR, RED_STRING_COMPARATOR);
		register(r, LibBlockNames.RED_STRING_RELAY, RED_STRING_RELAY);
		register(r, LibBlockNames.MANA_FLAME, MANA_FLAME);
		register(r, LibBlockNames.PRISM, PRISM);
		register(r, LibBlockNames.CORPOREA_INDEX, CORPOREA_INDEX);
		register(r, LibBlockNames.CORPOREA_FUNNEL, CORPOREA_FUNNEL);
		register(r, LibBlockNames.PUMP, PUMP);
		register(r, LibBlockNames.FAKE_AIR, FAKE_AIR);
		register(r, LibBlockNames.CORPOREA_INTERCEPTOR, CORPOREA_INTERCEPTOR);
		register(r, LibBlockNames.CORPOREA_CRYSTAL_CUBE, CORPOREA_CRYSTAL_CUBE);
		register(r, LibBlockNames.INCENSE_PLATE, INCENSE_PLATE);
		register(r, LibBlockNames.HOURGLASS, HOURGLASS);
		register(r, LibBlockNames.SPARK_CHANGER, SPARK_CHANGER);
		register(r, LibBlockNames.COCOON, COCOON);
		register(r, LibBlockNames.LIGHT_RELAY, LIGHT_RELAY);
		register(r, LibBlockNames.CACOPHONIUM, CACOPHONIUM);
		register(r, LibBlockNames.BELLOWS, BELLOWS);
		register(r, LibBlockNames.CELL_BLOCK, CELL_BLOCK);
		register(r, LibBlockNames.RED_STRING_INTERCEPTOR, RED_STRING_INTERCEPTOR);
		register(r, LibBlockNames.GAIA_HEAD, GAIA_HEAD);
		register(r, LibBlockNames.CORPOREA_RETAINER, CORPOREA_RETAINER);
		register(r, LibBlockNames.TERU_TERU_BOZU, TERU_TERU_BOZU);
		register(r, LibBlockNames.AVATAR, AVATAR);
		register(r, LibBlockNames.ANIMATED_TORCH, ANIMATED_TORCH);
	}
}
