/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.generating;

import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ModSounds;

public class SubTileThermalily extends SubTileHydroangeas {
	public SubTileThermalily() {
		super(ModSubtiles.THERMALILY);
	}

	@Override
	public int getColor() {
		return 0xD03C00;
	}

	@Override
	public void doBurnParticles() {
		WispParticleData data = WispParticleData.wisp((float) Math.random() / 6, 0.7F, 0.05F, 0.05F, 1);
		field_11863.method_8406(data, getEffectivePos().method_10263() + 0.55 + Math.random() * 0.2 - 0.1, getEffectivePos().method_10264() + 0.9 + Math.random() * 0.2 - 0.1, getEffectivePos().method_10260() + 0.5, 0, (float) Math.random() / 60, 0);
	}

	@Override
	public class_3494<class_3611> getMaterialToSearchFor() {
		return class_3486.field_15518;
	}

	@Override
	public void playSound() {
		method_10997().method_8396(null, getEffectivePos(), ModSounds.thermalily, class_3419.field_15245, 0.2F, 1F);
	}

	@Override
	public int getDelayBetweenPassiveGeneration() {
		return 1;
	}

	@Override
	public int getBurnTime() {
		return 900;
	}

	@Override
	public int getValueForPassiveGeneration() {
		return 20;
	}

	@Override
	public int getMaxMana() {
		return 500;
	}

	@Override
	public int getCooldown() {
		return 6000;
	}

	@Override
	public boolean isPassiveFlower() {
		return false;
	}
}
