/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.generating;

import com.mojang.blaze3d.systems.RenderSystem;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1472;
import net.minecraft.class_1542;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.helper.ColorHelper;
import vazkii.botania.mixin.AccessorItemEntity;

import java.util.List;
import java.util.function.Predicate;

public class SubTileSpectrolus extends TileEntityGeneratingFlower {
	public static final String TAG_NEXT_COLOR = "nextColor";
	private static final int WOOL_GEN = 1200;
	private static final int SHEEP_GEN = 5000;
	private static final int BABY_SHEEP_GEN = 1; // you are a monster

	private static final int RANGE = 1;

	private class_1767 nextColor = class_1767.field_7952;

	public SubTileSpectrolus() {
		super(ModSubtiles.SPECTROLUS);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236) {
			return;
		}

		// sheep need to enter the actual block space
		List<class_1297> targets = method_10997().method_8390(class_1472.class, new class_238(getEffectivePos()), class_1297::method_5805);

		class_238 itemAABB = new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1));
		int slowdown = getSlowdownFactor();
		Predicate<class_1297> selector = e -> (e instanceof class_1542 && e.method_5805() && ((AccessorItemEntity) e).getAge() >= slowdown);
		targets.addAll(method_10997().method_8390(class_1297.class, itemAABB, selector));

		for (class_1297 target : targets) {
			if (target instanceof class_1472) {
				class_1472 sheep = (class_1472) target;
				if (!sheep.method_6629() && sheep.method_6633() == nextColor) {
					addManaAndCycle(sheep.method_6109() ? BABY_SHEEP_GEN : SHEEP_GEN);
					float pitch = sheep.method_6109() ? (field_11863.field_9229.nextFloat() - field_11863.field_9229.nextFloat()) * 0.2F + 1.5F : (field_11863.field_9229.nextFloat() - field_11863.field_9229.nextFloat()) * 0.2F + 1.0F;
					sheep.method_5783(class_3417.field_14814, 0.9F, pitch);
					sheep.method_5783(class_3417.field_20614, 1, 1);

					class_1799 morbid = new class_1799(sheep.method_5809() ? class_1802.field_8347 : class_1802.field_8748);
					((class_3218) method_10997()).method_14199(new class_2392(class_2398.field_11218, morbid), target.method_23317(), target.method_23318() + target.method_5751(), target.method_23321(), 20, 0.1D, 0.1D, 0.1D, 0.05D);

					class_1799 wool = new class_1799(ColorHelper.WOOL_MAP.apply(sheep.method_6633()));
					((class_3218) method_10997()).method_14199(new class_2392(class_2398.field_11218, wool), target.method_23317(), target.method_23318() + target.method_5751(), target.method_23321(), 20, 0.1D, 0.1D, 0.1D, 0.05D);
				}
				sheep.method_6033(0);
			} else if (target instanceof class_1542) {
				class_1799 stack = ((class_1542) target).method_6983();

				if (!stack.method_7960() && ColorHelper.isWool(class_2248.method_9503(stack.method_7909()))) {
					class_2248 expected = ColorHelper.WOOL_MAP.apply(nextColor);

					if (expected.method_8389() == stack.method_7909()) {
						addManaAndCycle(WOOL_GEN);
						((class_3218) method_10997()).method_14199(new class_2392(class_2398.field_11218, stack), target.method_23317(), target.method_23318(), target.method_23321(), 20, 0.1D, 0.1D, 0.1D, 0.05D);
					}

					target.method_5650();
				}
			}
		}
	}

	private void addManaAndCycle(int toAdd) {
		addMana(toAdd);
		nextColor = nextColor == class_1767.field_7963 ? class_1767.field_7952 : class_1767.values()[nextColor.ordinal() + 1];
		sync();
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), RANGE);
	}

	@Override
	public int getMaxMana() {
		return 16000;
	}

	@Override
	public int getColor() {
		return class_3532.method_15369(ticksExisted * 2 % 360 / 360F, 1F, 1F);
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void renderHUD(class_4587 ms, class_310 mc) {
		super.renderHUD(ms, mc);

		class_1799 stack = new class_1799(ColorHelper.WOOL_MAP.apply(nextColor));
		int color = getColor();

		if (!stack.method_7960()) {
			class_2561 stackName = stack.method_7964();
			int width = 16 + mc.field_1772.method_27525(stackName) / 2;
			int x = mc.method_22683().method_4486() / 2 - width;
			int y = mc.method_22683().method_4502() / 2 + 30;

			mc.field_1772.method_30881(ms, stackName, x + 20, y + 5, color);
			mc.method_1480().method_4023(stack, x, y);
		}

		RenderSystem.disableLighting();
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);
		cmp.method_10569(TAG_NEXT_COLOR, nextColor.ordinal());
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);
		nextColor = class_1767.method_7791(cmp.method_10550(TAG_NEXT_COLOR));
	}
}
