/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.generating;

import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.components.EntityComponents;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1621;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2919;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;

public class SubTileNarslimmus extends TileEntityGeneratingFlower {

	private static final int RANGE = 2;

	public SubTileNarslimmus() {
		super(ModSubtiles.NARSLIMMUS);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (ticksExisted % 5 == 0) {
			List<class_1621> slimes = method_10997().method_18467(class_1621.class, new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1)));
			for (class_1621 slime : slimes) {
				if (slime.method_5805() && EntityComponents.NARSLIMMUS.get(slime).isNaturalSpawned()) {
					int size = slime.method_7152();
					int mul = (int) Math.pow(2, size);
					int mana = 1200 * mul;
					if (!slime.field_6002.field_9236) {
						slime.method_5650();
						slime.method_5783(size > 1 ? class_3417.field_15095 : class_3417.field_15148, 1, 0.02F);
						addMana(mana);
						sync();
					}

					for (int j = 0; j < mul * 8; ++j) {
						float f = slime.field_6002.field_9229.nextFloat() * (float) Math.PI * 2.0F;
						float f1 = slime.field_6002.field_9229.nextFloat() * 0.5F + 0.5F;
						float f2 = class_3532.method_15374(f) * size * 0.5F * f1;
						float f3 = class_3532.method_15362(f) * size * 0.5F * f1;
						float f4 = slime.field_6002.field_9229.nextFloat() * size * 0.5F * f1;
						slime.field_6002.method_8406(class_2398.field_11246, slime.method_23317() + f2, slime.method_5829().field_1322 + f4, slime.method_23321() + f3, 0.0D, 0.0D, 0.0D);
					}
					break;
				}
			}
		}
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), RANGE);
	}

	@Override
	public int getMaxMana() {
		return 12000;
	}

	@Override
	public int getColor() {
		return 0x71C373;
	}

	public static void onSpawn(class_1297 entity) {
		boolean slimeChunk = isSlimeChunk(entity.field_6002, entity.method_23317(), entity.method_23321());
		if (slimeChunk) {
			entity.method_24204().forEach(e -> {
				if (e instanceof class_1621) {
					EntityComponents.NARSLIMMUS.get(e).setNaturalSpawn(true);
				}
			});
		}
	}

	private static boolean isSlimeChunk(class_1937 world, double x, double z) {
		return isSlimeChunk(world, new class_2338(x, 0, z));
	}

	public static boolean isSlimeChunk(class_1937 world, class_2338 pos) {
		class_1923 chunkpos = new class_1923(pos);
		return class_2919.method_12662(chunkpos.field_9181, chunkpos.field_9180, ((class_3218) world).method_8412(), 987234911L).nextInt(10) == 0;
	}

}
