/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.generating;

import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ConfigHandler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3481;

public class SubTileMunchdew extends TileEntityGeneratingFlower {
	public static final String TAG_COOLDOWN = "cooldown";
	private static final String TAG_ATE_ONCE = "ateOnce";

	private static final int RANGE = 8;
	private static final int RANGE_Y = 16;

	private boolean ateOnce = false;
	private int ticksWithoutEating = -1;
	private int cooldown = 0;

	public SubTileMunchdew() {
		super(ModSubtiles.MUNCHDEW);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236) {
			return;
		}

		if (cooldown > 0) {
			cooldown--;
			ticksWithoutEating = 0;
			ateOnce = false; // don't start ticking ticksWithoutEating again until we eat again
			return;
		}

		int manaPerLeaf = 160;
		eatLeaves: {
			if (getMaxMana() - getMana() >= manaPerLeaf && ticksExisted % 4 == 0) {
				List<class_2338> coords = new ArrayList<>();
				class_2338 pos = getEffectivePos();

				nextCoord: for (class_2338 pos_ : class_2338.method_10097(pos.method_10069(-RANGE, 0, -RANGE),
						pos.method_10069(RANGE, RANGE_Y, RANGE))) {
					if (method_10997().method_8320(pos_).method_26204().method_9525(class_3481.field_15503)) {
						for (class_2350 dir : class_2350.values()) {
							if (method_10997().method_22347(pos_.method_10093(dir))) {
								coords.add(pos_.method_10062());
								break nextCoord;
							}
						}
					}
				}

				if (coords.isEmpty()) {
					break eatLeaves;
				}

				Collections.shuffle(coords);
				class_2338 breakCoords = coords.get(0);
				class_2680 state = method_10997().method_8320(breakCoords);
				method_10997().method_8650(breakCoords, false);
				ticksWithoutEating = 0;
				ateOnce = true;
				if (ConfigHandler.COMMON.blockBreakParticles.getValue()) {
					method_10997().method_20290(2001, breakCoords, class_2248.method_9507(state));
				}
				addMana(manaPerLeaf);
			}
		}

		if (ateOnce) {
			ticksWithoutEating++;
			if (ticksWithoutEating >= 5) {
				cooldown = 1600;
				sync();
			}
		}
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), RANGE);
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);

		cmp.method_10569(TAG_COOLDOWN, cooldown);
		cmp.method_10556(TAG_ATE_ONCE, ateOnce);
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);

		cooldown = cmp.method_10550(TAG_COOLDOWN);
		ateOnce = cmp.method_10577(TAG_ATE_ONCE);
	}

	@Override
	public int getColor() {
		return 0x79C42F;
	}

	@Override
	public int getMaxMana() {
		return 10000;
	}

}
