/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.generating;

import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModSubtiles;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3610;
import net.minecraft.class_3611;

public class SubTileHydroangeas extends TileEntityGeneratingFlower {
	private static final String TAG_BURN_TIME = "burnTime";
	public static final String TAG_COOLDOWN = "cooldown";

	private static final class_2338[] OFFSETS = { new class_2338(0, 0, 1), new class_2338(0, 0, -1), new class_2338(1, 0, 0), new class_2338(-1, 0, 0), new class_2338(-1, 0, 1), new class_2338(-1, 0, -1), new class_2338(1, 0, 1), new class_2338(1, 0, -1) };

	int burnTime, cooldown;

	public SubTileHydroangeas() {
		this(ModSubtiles.HYDROANGEAS);
	}

	public SubTileHydroangeas(class_2591<?> type) {
		super(type);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (cooldown > 0) {
			cooldown--;
			for (int i = 0; i < 3; i++) {
				WispParticleData data = WispParticleData.wisp((float) Math.random() / 6, 0.1F, 0.1F, 0.1F, 1);
				field_11863.method_8406(data, getEffectivePos().method_10263() + 0.5 + Math.random() * 0.2 - 0.1, getEffectivePos().method_10264() + 0.5 + Math.random() * 0.2 - 0.1, getEffectivePos().method_10260() + 0.5 + Math.random() * 0.2 - 0.1, 0, (float) Math.random() / 30, 0);
			}
		}

		if (burnTime == 0) {
			if (getMana() < getMaxMana() && !method_10997().field_9236) {
				List<class_2338> offsets = Arrays.asList(OFFSETS);
				Collections.shuffle(offsets);

				for (class_2338 offset : offsets) {
					class_2338 pos = getEffectivePos().method_10081(offset);

					class_3610 fstate = method_10997().method_8316(pos);
					class_3494<class_3611> search = getMaterialToSearchFor();
					if (fstate.method_15767(search) && fstate.method_15771()) {
						if (search != class_3486.field_15517) {
							method_10997().method_8501(pos, class_2246.field_10124.method_9564());
						} else {
							int waterAround = 0;
							for (class_2350 dir : class_2350.values()) {
								if (method_10997().method_8316(pos.method_10093(dir)).method_15767(search)) {
									waterAround++;
								}
							}

							if (waterAround < 2) {
								method_10997().method_8501(pos, class_2246.field_10124.method_9564());
							}
						}

						if (cooldown == 0) {
							burnTime += getBurnTime();
						} else {
							cooldown = getCooldown();
						}

						sync();
						playSound();
						break;
					}
				}
			}
		} else {
			if (method_10997().field_9229.nextInt(8) == 0) {
				doBurnParticles();
			}
			burnTime--;
			if (burnTime == 0) {
				cooldown = getCooldown();
				sync();
			}
		}
	}

	public void doBurnParticles() {
		WispParticleData data = WispParticleData.wisp((float) Math.random() / 6, 0.05F, 0.05F, 0.7F, 1);
		field_11863.method_8406(data, getEffectivePos().method_10263() + 0.55 + Math.random() * 0.2 - 0.1, getEffectivePos().method_10264() + 0.55 + Math.random() * 0.2 - 0.1, getEffectivePos().method_10260() + 0.5, 0, (float) Math.random() / 60, 0);
	}

	public class_3494<class_3611> getMaterialToSearchFor() {
		return class_3486.field_15517;
	}

	public void playSound() {
		method_10997().method_8396(null, getEffectivePos(), class_3417.field_20613, class_3419.field_15245, 0.01F, 0.5F + (float) Math.random() * 0.5F);
	}

	public int getBurnTime() {
		return 40;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), 1);
	}

	@Override
	public int getMaxMana() {
		return 150;
	}

	@Override
	public int getColor() {
		return 0x532FE0;
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);

		cmp.method_10569(TAG_BURN_TIME, burnTime);
		cmp.method_10569(TAG_COOLDOWN, cooldown);
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);

		burnTime = cmp.method_10550(TAG_BURN_TIME);
		cooldown = cmp.method_10550(TAG_COOLDOWN);
	}

	@Override
	public boolean canGeneratePassively() {
		return burnTime > 0;
	}

	@Override
	public int getDelayBetweenPassiveGeneration() {
		boolean rain = method_10997().method_23753(getEffectivePos()).method_8694() == class_1959.class_1963.field_9382 && (method_10997().method_8419() || method_10997().method_8546());
		return rain ? 2 : 3;
	}

	public int getCooldown() {
		return 0;
	}

	@Override
	public boolean isPassiveFlower() {
		return true;
	}

}
