/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.generating;

import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ExperienceHelper;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_238;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class SubTileArcaneRose extends TileEntityGeneratingFlower {
	private static final int MANA_PER_XP = 50;
	private static final int MANA_PER_XP_ORB = 35;
	private static final int MANA_PER_XP_DISENCHANT = 40;
	private static final int RANGE = 1;

	public SubTileArcaneRose() {
		super(ModSubtiles.ROSA_ARCANA);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (field_11863.field_9236 || getMana() >= getMaxMana()) {
			return;
		}

		class_238 effectBounds = new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1));

		List<class_1657> players = method_10997().method_18467(class_1657.class, effectBounds);
		for (class_1657 player : players) {
			if (ExperienceHelper.getPlayerXP(player) >= 1 && player.method_24828()) {
				ExperienceHelper.drainPlayerXP(player, 1);
				addMana(MANA_PER_XP);
				sync();
				return;
			}
		}

		List<class_1303> orbs = method_10997().method_18467(class_1303.class, effectBounds);
		for (class_1303 orb : orbs) {
			if (orb.method_5805()) {
				addMana(orb.method_5919() * 35);
				orb.method_5650();
				float pitch = (field_11863.field_9229.nextFloat() - field_11863.field_9229.nextFloat()) * 0.35F + 0.9F;
				field_11863.method_8396(null, getEffectivePos(), class_3417.field_14627, class_3419.field_15245, 0.07F, pitch);
				sync();
				return;
			}
		}

		List<class_1542> items = method_10997().method_8390(class_1542.class, effectBounds, e -> e.method_5805() && !e.method_6983().method_7960());
		for (class_1542 entity : items) {
			class_1799 stack = entity.method_6983();
			if (stack.method_7909() == class_1802.field_8598 || stack.method_7942()) {
				int xp = getEnchantmentXpValue(stack);
				if (xp > 0) {
					class_1799 newStack = removeNonCurses(stack);
					newStack.method_7939(1);
					stack.method_7934(1);

					class_1542 newEntity = new class_1542(field_11863, entity.method_23317(), entity.method_23318(), entity.method_23321(), newStack);
					newEntity.method_18799(entity.method_18798());
					field_11863.method_8649(newEntity);

					field_11863.method_8396(null, getEffectivePos(), ModSounds.arcaneRoseDisenchant, class_3419.field_15245, 0.3F, this.field_11863.field_9229.nextFloat() * 0.1F + 0.9F);
					while (xp > 0) {
						int i = class_1303.method_5918(xp);
						xp -= i;
						field_11863.method_8649(new class_1303(field_11863, getEffectivePos().method_10263() + 0.5D, getEffectivePos().method_10264() + 0.5D, getEffectivePos().method_10260() + 0.5D, i));
					}
					return;
				}
			}
		}
	}

	// [VanillaCopy] GrindstoneContainer
	private static int getEnchantmentXpValue(class_1799 stack) {
		int ret = 0;
		Map<class_1887, Integer> map = class_1890.method_8222(stack);

		for (Map.Entry<class_1887, Integer> entry : map.entrySet()) {
			class_1887 enchantment = entry.getKey();
			Integer integer = entry.getValue();
			if (!enchantment.method_8195()) {
				ret += enchantment.method_8182(integer);
			}
		}

		return ret;
	}

	// [VanillaCopy] GrindstoneContainer, no damage and count setting
	private static class_1799 removeNonCurses(class_1799 stack) {
		class_1799 itemstack = stack.method_7972();
		itemstack.method_7983("Enchantments");
		itemstack.method_7983("StoredEnchantments");

		Map<class_1887, Integer> map = class_1890.method_8222(stack).entrySet().stream().filter((p_217012_0_) -> {
			return p_217012_0_.getKey().method_8195();
		}).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
		class_1890.method_8214(map, itemstack);
		itemstack.method_7927(0);
		if (itemstack.method_7909() == class_1802.field_8598 && map.size() == 0) {
			itemstack = new class_1799(class_1802.field_8529);
			if (stack.method_7938()) {
				itemstack.method_7977(stack.method_7964());
			}
		}

		for (int i = 0; i < map.size(); ++i) {
			itemstack.method_7927(class_1706.method_20398(itemstack.method_7928()));
		}

		return itemstack;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), RANGE);
	}

	@Override
	public int getColor() {
		return 0xFF8EF8;
	}

	@Override
	public int getMaxMana() {
		return 6000;
	}

}
