/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.mixin.*;

import java.util.ArrayList;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1338;
import net.minecraft.class_1355;
import net.minecraft.class_1400;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_3417;
import net.minecraft.class_4135;

public class SubTileTigerseye extends TileEntityFunctionalFlower {
	private static final int RANGE = 10;
	private static final int RANGE_Y = 4;
	private static final int COST = 70;
	private static final int SUCCESS_EVENT = 0;

	public SubTileTigerseye() {
		super(ModSubtiles.TIGERSEYE);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236) {
			return;
		}

		for (class_1548 entity : method_10997().method_18467(class_1548.class, new class_238(getEffectivePos().method_10069(-RANGE, -RANGE_Y, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE_Y + 1, RANGE + 1)))) {
			((AccessorCreeperEntity) entity).setCurrentFuseTime(2);
			entity.method_5980(null);

			if (getMana() >= COST) {
				boolean did = false;

				class_1355 goalSelector = ((AccessorMobEntity) entity).getGoalSelector();
				Set<class_4135> goals = ((AccessorGoalSelector) goalSelector).getGoals();
				boolean hasRunAwayFromPlayerGoal = goals.stream()
						.anyMatch(g -> g.method_19058() instanceof class_1338 && ((AccessorAvoidEntityGoal) g.method_19058()).getClassToFleeFrom() == class_1657.class);
				if (!hasRunAwayFromPlayerGoal) {
					goalSelector.method_6277(3, new class_1338<>(entity, class_1657.class, 6, 1, 1.2));
					did = true;
				}

				class_1355 targetSelector = ((AccessorMobEntity) entity).getTargetSelector();
				for (class_4135 pg : new ArrayList<>(((AccessorGoalSelector) targetSelector).getGoals())) {
					if (pg.method_19058() instanceof class_1400
							&& ((AccessorNearestAttackableTarget) pg.method_19058()).getTargetClass() == class_1657.class) {
						targetSelector.method_6280(pg.method_19058());
						did = true;
					}
				}

				if (did) {
					entity.method_5783(class_3417.field_15192, 1.0F, (field_11863.field_9229.nextFloat() - field_11863.field_9229.nextFloat()) * 0.2F + 1.0F);
					field_11863.method_8427(method_11016(), method_11010().method_26204(), SUCCESS_EVENT, entity.method_5628());
					addMana(-COST);
					sync();
				}
			}
		}
	}

	@Override
	public boolean method_11004(int id, int payload) {
		if (id == SUCCESS_EVENT) {
			if (field_11863.field_9236) {
				class_1297 e = field_11863.method_8469(payload);
				if (e != null) {
					float r = (getColor() >> 16 & 0xFF) / 255F;
					float g = (getColor() >> 8 & 0xFF) / 255F;
					float b = (getColor() & 0xFF) / 255F;
					SparkleParticleData data = SparkleParticleData.sparkle(field_11863.field_9229.nextFloat(), r, g, b, 10);

					for (int i = 0; i < 50; i++) {
						double x = e.method_23317() + field_11863.field_9229.nextDouble() - 0.5;
						double y = e.method_23318() + e.method_17682() * field_11863.field_9229.nextDouble();
						double z = e.method_23321() + field_11863.field_9229.nextDouble() - 0.5;
						field_11863.method_8406(data, x, y, z, 0, 0, 0);
					}
				}
			}
			return true;
		}
		return super.method_11004(id, payload);
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), RANGE);
	}

	@Override
	public int getColor() {
		return 0xB1A618;
	}

	@Override
	public int getMaxMana() {
		return 1000;
	}

}
