/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;

import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_2591;

public class SubTileTangleberrie extends TileEntityFunctionalFlower {
	public SubTileTangleberrie(class_2591<?> type) {
		super(type);
	}

	public SubTileTangleberrie() {
		this(ModSubtiles.TANGLEBERRIE);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (getMana() > 0) {
			double x1 = getEffectivePos().method_10263() + 0.5;
			double y1 = getEffectivePos().method_10264() + 0.5;
			double z1 = getEffectivePos().method_10260() + 0.5;

			double maxDist = getMaxDistance();
			double range = getRange();

			class_238 boundingBox = new class_238(x1 - range, y1 - range, z1 - range, x1 + range + 1, y1 + range + 1, z1 + range + 1);
			List<class_1309> entities = method_10997().method_18467(class_1309.class, boundingBox);

			SparkleParticleData data = SparkleParticleData.sparkle(1F, 0.5F, 0.5F, 0.5F, 3);
			for (class_1309 entity : entities) {
				if (entity instanceof class_1657 || !entity.method_5822()) {
					continue;
				}

				double x2 = entity.method_23317();
				double y2 = entity.method_23318();
				double z2 = entity.method_23321();

				float distance = MathHelper.pointDistanceSpace(x1, y1, z1, x2, y2, z2);

				if (distance > maxDist && distance < range) {
					MathHelper.setEntityMotionFromVector(entity, new Vector3(x1, y1, z1), getMotionVelocity(entity));
					if (method_10997().field_9229.nextInt(3) == 0) {
						field_11863.method_8406(data, x2 + Math.random() * entity.method_17681(), y2 + Math.random() * entity.method_17682(), z2 + Math.random() * entity.method_17681(), 0, 0, 0);
					}
				}
			}

			if (ticksExisted % 4 == 0) {
				addMana(-1);
				sync();
			}
		}
	}

	double getMaxDistance() {
		return 6;
	}

	double getRange() {
		return 7;
	}

	float getMotionVelocity(class_1309 entity) {
		return Math.max(entity.method_6029() / 2F, 0.05F);
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Circle(getEffectivePos(), getRange());
	}

	@Override
	public RadiusDescriptor getSecondaryRadius() {
		if (getMaxDistance() == getRange()) {
			return null;
		}
		return new RadiusDescriptor.Circle(getEffectivePos(), getMaxDistance());
	}

	@Override
	public int getColor() {
		return 0x4B797C;
	}

	@Override
	public int getMaxMana() {
		return 20;
	}

}
