/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.components.EntityComponents;
import vazkii.botania.common.components.ItemFlagsComponent;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.mixin.AccessorItemEntity;

import java.util.List;

public class SubTileSpectranthemum extends TileEntityFunctionalFlower {
	private static final String TAG_BIND_X = "bindX";
	private static final String TAG_BIND_Y = "bindY";
	private static final String TAG_BIND_Z = "bindZ";

	private static final int COST = 24;
	private static final int RANGE = 2;
	private static final int BIND_RANGE = 12;

	public static final String TAG_TELEPORTED = "botania:teleported";

	private class_2338 bindPos = new class_2338(0, -1, 0);

	public SubTileSpectranthemum() {
		super(ModSubtiles.SPECTRANTHEMUM);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (!method_10997().field_9236 && redstoneSignal == 0 && method_10997().method_22340(bindPos)) {
			class_2338 pos = getEffectivePos();

			boolean did = false;

			List<class_1542> items = method_10997().method_18467(class_1542.class, new class_238(pos.method_10069(-RANGE, -RANGE, -RANGE), pos.method_10069(RANGE + 1, RANGE + 1, RANGE + 1)));
			int slowdown = getSlowdownFactor();

			for (class_1542 item : items) {
				ItemFlagsComponent flags = EntityComponents.INTERNAL_ITEM.get(item);
				int age = ((AccessorItemEntity) item).getAge();
				if (age < 60 + slowdown || !item.method_5805() || flags.spectranthemumTeleported) {
					continue;
				}

				class_1799 stack = item.method_6983();
				if (!stack.method_7960()) {
					class_1792 sitem = stack.method_7909();
					if (sitem instanceof IManaItem) {
						continue;
					}

					int cost = stack.method_7947() * COST;
					if (getMana() >= cost) {
						spawnExplosionParticles(item, 10);
						item.method_5814(bindPos.method_10263() + 0.5, bindPos.method_10264() + 1.5, bindPos.method_10260() + 0.5);
						flags.spectranthemumTeleported = true;
						item.method_18799(class_243.field_1353);
						spawnExplosionParticles(item, 10);
						addMana(-cost);
						did = true;
					}
				}
			}

			if (did) {
				sync();
			}
		}
	}

	static void spawnExplosionParticles(class_1297 item, int p) {
		PacketBotaniaEffect.sendNearby(item, PacketBotaniaEffect.EffectType.ITEM_SMOKE, item.method_23317(), item.method_23318(), item.method_23321(), item.method_5628(), p);
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), RANGE);
	}

	@Override
	public RadiusDescriptor getSecondaryRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), BIND_RANGE);
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);
		cmp.method_10569(TAG_BIND_X, bindPos.method_10263());
		cmp.method_10569(TAG_BIND_Y, bindPos.method_10264());
		cmp.method_10569(TAG_BIND_Z, bindPos.method_10260());
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);
		bindPos = new class_2338(
				cmp.method_10550(TAG_BIND_X),
				cmp.method_10550(TAG_BIND_Y),
				cmp.method_10550(TAG_BIND_Z)
		);
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	@Override
	public int getColor() {
		return 0x98BCFF;
	}

	@Override
	public int getMaxMana() {
		return 16000;
	}

	@Override
	public boolean bindTo(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
		boolean bound = super.bindTo(player, wand, pos, side);

		if (!bound && !pos.equals(bindPos) && pos.method_10262(getEffectivePos()) <= BIND_RANGE * BIND_RANGE && !pos.equals(getEffectivePos())) {
			bindPos = pos;
			sync();

			return true;
		}

		return bound;
	}

	@Override
	@Environment(EnvType.CLIENT)
	public class_2338 getBinding() {
		return class_310.method_1551().field_1724.method_5715() && bindPos.method_10264() != -1 ? bindPos : super.getBinding();
	}

}
