/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.collect.MapMaker;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;

import java.util.Collections;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2591;

public class SubTileSolegnolia extends TileEntityFunctionalFlower {
	private static final double RANGE = 5;
	private static final double RANGE_MINI = 1;

	private static final Set<SubTileSolegnolia> existingFlowers = Collections.newSetFromMap(new MapMaker().concurrencyLevel(2).weakKeys().makeMap());

	public SubTileSolegnolia(class_2591<?> type) {
		super(type);
	}

	public SubTileSolegnolia() {
		this(ModSubtiles.SOLEGNOLIA);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (!existingFlowers.contains(this)) {
			existingFlowers.add(this);
		}
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	public static boolean hasSolegnoliaAround(class_1297 e) {
		return existingFlowers.stream()
				.filter(f -> f.redstoneSignal == 0)
				.filter(f -> f.method_10997() == e.field_6002)
				.anyMatch(f -> f.getEffectivePos().method_10268(e.method_23317(), e.method_23318(), e.method_23321(), false) <= f.getRange() * f.getRange());
	}

	@Override
	public int getMaxMana() {
		return 1;
	}

	@Override
	public int getColor() {
		return 0xC99C4D;
	}

	public double getRange() {
		return RANGE;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Circle(getEffectivePos(), getRange());
	}

	public static class Mini extends SubTileSolegnolia {
		public Mini() {
			super(ModSubtiles.SOLEGNOLIA_CHIBI);
		}

		@Override
		public double getRange() {
			return RANGE_MINI;
		}
	}

}
