/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.collect.ImmutableList;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.util.math.*;
import vazkii.botania.api.item.IFlowerPlaceable;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.mixin.AccessorItemEntity;

import javax.annotation.Nonnull;

import java.util.*;

public class SubTileRannuncarpus extends TileEntityFunctionalFlower {
	private static final int PICKUP_RANGE = 2;
	private static final int PICKUP_RANGE_Y = 3;
	private static final int RANGE_PLACE_MANA = 8;
	private static final int RANGE_PLACE = 6;
	private static final int RANGE_PLACE_Y = 6;

	private static final int RANGE_PLACE_MANA_MINI = 3;
	private static final int RANGE_PLACE_MINI = 2;
	private static final int RANGE_PLACE_Y_MINI = 2;

	public SubTileRannuncarpus(class_2591<?> type) {
		super(type);
	}

	public SubTileRannuncarpus() {
		this(ModSubtiles.RANNUNCARPUS);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236 || redstoneSignal > 0) {
			return;
		}

		if (ticksExisted % 10 == 0) {
			List<class_1542> items = method_10997().method_18467(class_1542.class, new class_238(getEffectivePos().method_10069(-PICKUP_RANGE, -PICKUP_RANGE_Y, -PICKUP_RANGE), getEffectivePos().method_10069(PICKUP_RANGE + 1, PICKUP_RANGE_Y + 1, PICKUP_RANGE + 1)));
			List<class_2338> validPositions = getCandidatePositions();
			int slowdown = getSlowdownFactor();

			for (class_1542 item : items) {
				int age = ((AccessorItemEntity) item).getAge();
				if (age < 60 + slowdown || !item.method_5805() || item.method_6983().method_7960()) {
					continue;
				}

				class_1799 stack = item.method_6983();
				class_1792 stackItem = stack.method_7909();
				class_2960 id = class_2378.field_11142.method_10221(stackItem);
				if (ConfigHandler.blacklistedRannuncarpusModIds.contains(id.method_12836())
						|| ConfigHandler.blacklistedRannuncarpusItems.contains(id)) {
					continue;
				}

				if (stackItem instanceof class_1747 || stackItem instanceof IFlowerPlaceable) {
					if (!validPositions.isEmpty()) {
						class_2338 coords = validPositions.get(method_10997().field_9229.nextInt(validPositions.size()));
						class_3965 ray = new class_3965(new class_243(coords.method_10263() + 0.5, coords.method_10264() + 1, coords.method_10260() + 0.5), class_2350.field_11036, coords, false);
						class_1750 ctx = new RannuncarpusPlaceContext(method_10997(), stack, ray, field_11867);

						boolean success = false;
						if (stackItem instanceof IFlowerPlaceable) {
							success = ((IFlowerPlaceable) stackItem).tryPlace(this, ctx);
						}
						if (stackItem instanceof class_1747) {
							success = ((class_1747) stackItem).method_7712(ctx).method_23665();
						}

						if (success) {
							if (ConfigHandler.COMMON.blockBreakParticles.getValue()) {
								class_2680 state = method_10997().method_8320(ctx.method_8037());
								method_10997().method_20290(2001, coords, class_2248.method_9507(state));
							}
							validPositions.remove(coords);
							if (getMana() > 1) {
								addMana(-1);
							}
							return;
						}
					}
				}
			}
		}
	}

	public class_2680 getUnderlyingBlock() {
		return method_10997().method_8320(getEffectivePos().method_10087(isFloating() ? 1 : 2));
	}

	private List<class_2338> getCandidatePositions() {
		int rangePlace = getPlaceRange();
		int rangePlaceY = getVerticalPlaceRange();
		class_2338 center = getEffectivePos();
		class_2680 filter = getUnderlyingBlock();
		List<class_2338> ret = new ArrayList<>();

		for (class_2338 pos : class_2338.method_10097(center.method_10069(-rangePlace, -rangePlaceY, -rangePlace),
				center.method_10069(rangePlace, rangePlaceY, rangePlace))) {
			class_2680 state = method_10997().method_8320(pos);
			class_2680 up = method_10997().method_8320(pos.method_10084());
			if (filter == state && (up.method_26215() || up.method_26207().method_15800())) {
				ret.add(pos.method_10062());
			}
		}
		return ret;
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void renderHUD(class_4587 ms, class_310 mc) {
		super.renderHUD(ms, mc);

		class_2680 filter = getUnderlyingBlock();
		class_1799 recieverStack = new class_1799(filter.method_26204());
		int color = getColor();

		if (!recieverStack.method_7960()) {
			class_2561 stackName = recieverStack.method_7964();
			int width = 16 + mc.field_1772.method_27525(stackName) / 2;
			int x = mc.method_22683().method_4486() / 2 - width;
			int y = mc.method_22683().method_4502() / 2 + 30;

			mc.field_1772.method_30881(ms, stackName, x + 20, y + 5, color);
			mc.method_1480().method_4023(recieverStack, x, y);
		}

	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), getPlaceRange());
	}

	@Override
	public RadiusDescriptor getSecondaryRadius() {
		if (getPlaceRange() == PICKUP_RANGE) {
			return null;
		}
		return new RadiusDescriptor.Square(getEffectivePos(), PICKUP_RANGE);
	}

	public int getPlaceRange() {
		return getMana() > 0 ? RANGE_PLACE_MANA : RANGE_PLACE;
	}

	public int getVerticalPlaceRange() {
		return RANGE_PLACE_Y;
	}

	@Override
	public int getMaxMana() {
		return 20;
	}

	@Override
	public int getColor() {
		return 0xFFB27F;
	}

	public static class Mini extends SubTileRannuncarpus {
		public Mini() {
			super(ModSubtiles.RANNUNCARPUS_CHIBI);
		}

		@Override
		public int getPlaceRange() {
			return getMana() > 0 ? RANGE_PLACE_MANA_MINI : RANGE_PLACE_MINI;
		}

		@Override
		public int getVerticalPlaceRange() {
			return RANGE_PLACE_Y_MINI;
		}
	}

	// BlockItemUseContext uses a nullable player field without checking it -.-
	private static class RannuncarpusPlaceContext extends class_1750 {
		private final class_2350[] lookDirs;
		private final float placementYaw;

		public RannuncarpusPlaceContext(class_1937 world, class_1799 stack, class_3965 rtr, class_2338 flowerPos) {
			super(world, null, class_1268.field_5808, stack, rtr);
			int dx = rtr.method_17777().method_10263() - flowerPos.method_10263();
			int dy = rtr.method_17777().method_10264() - flowerPos.method_10264();
			int dz = rtr.method_17777().method_10260() - flowerPos.method_10260();

			class_2350 xClosest = dx >= 0 ? class_2350.field_11034 : class_2350.field_11039;
			class_2350 yClosest = dy >= 0 ? class_2350.field_11036 : class_2350.field_11033;
			class_2350 zClosest = dz >= 0 ? class_2350.field_11035 : class_2350.field_11043;

			List<class_2350> directions = sortThree(xClosest, yClosest, zClosest, Math.abs(dx), Math.abs(dy), Math.abs(dz));

			class_2350 first = directions.get(0);
			class_2350 second = directions.get(1);
			class_2350 third = directions.get(2);

			lookDirs = new class_2350[] {
					first,
					second,
					third,
					third.method_10153(),
					second.method_10153(),
					first.method_10153()
			};

			placementYaw = (float) (-class_3532.method_15349(dx, dz) * 180 / Math.PI);
		}

		/**
		 * Arrange a, b and c such that their corresponding ints (a -> aInt) are in descending order.
		 */
		private static <T> List<T> sortThree(T a, T b, T c, int aInt, int bInt, int cInt) {
			if (aInt >= bInt) {
				if (bInt >= cInt) {
					return ImmutableList.of(a, b, c);
				} else {
					return cInt >= aInt ? ImmutableList.of(c, a, b) : ImmutableList.of(a, c, b);
				}
			} else if (bInt >= cInt) {
				return cInt >= aInt ? ImmutableList.of(b, c, a) : ImmutableList.of(b, a, c);
			} else {
				return ImmutableList.of(c, b, a);
			}
		}

		@Nonnull
		@Override
		public class_2350 method_7715() {
			return method_7718()[0];
		}

		@Nonnull
		@Override
		public class_2350[] method_7718() {
			return lookDirs;
		}

		@Nonnull
		@Override
		public class_2350 method_8042() {
			return method_7715().method_10166().method_10179() ? method_7715() : method_7718()[1];
		}

		@Override
		public float method_8044() {
			return placementYaw;
		}
	}

}
