/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.mixin.AccessorItemEntity;

import java.util.List;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_238;

public class SubTilePollidisiac extends TileEntityFunctionalFlower {
	private static final int RANGE = 6;
	private static final int MANA_COST = 12;

	public SubTilePollidisiac() {
		super(ModSubtiles.POLLIDISIAC);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (!method_10997().field_9236) {

			List<class_1542> items = method_10997().method_18467(class_1542.class, new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1)));
			List<class_1429> animals = method_10997().method_18467(class_1429.class, new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1)));
			int slowdown = getSlowdownFactor();

			for (class_1429 animal : animals) {
				if (getMana() < MANA_COST) {
					break;
				}

				if (animal.method_5618() == 0 && !animal.method_6479()) {
					for (class_1542 item : items) {
						int age = ((AccessorItemEntity) item).getAge();
						if (age < 60 + slowdown || !item.method_5805()) {
							continue;
						}

						class_1799 stack = item.method_6983();
						if (!stack.method_7960() && animal.method_6481(stack)) {
							stack.method_7934(1);

							addMana(-MANA_COST);
							animal.method_6476(1200);
							method_10997().method_8421(animal, (byte) 18);
						}
					}
				}
			}
		}
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), RANGE);
	}

	@Override
	public int getMaxMana() {
		return 120;
	}

	@Override
	public int getColor() {
		return 0xCF4919;
	}

}
