/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.ModSubtiles;

import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class SubTileOrechidIgnem extends SubTileOrechid {
	private static final int COST = 20000;

	public SubTileOrechidIgnem() {
		super(ModSubtiles.ORECHID_IGNEM);
	}

	@Override
	public boolean canOperate() {
		return method_10997().method_8597().method_27998();
	}

	@Override
	public Map<class_2960, Integer> getOreMap() {
		return BotaniaAPI.instance().getNetherOreWeights();
	}

	@Override
	public Predicate<class_2680> getReplaceMatcher() {
		return state -> state.method_26204() == class_2246.field_10515;
	}

	@Override
	public int getCost() {
		return COST;
	}

	@Override
	public int getColor() {
		return 0xAE3030;
	}

}
