/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ModSounds;

import javax.annotation.Nullable;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3549;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SubTileOrechid extends TileEntityFunctionalFlower {
	private static final int COST = 17500;
	private static final int COST_GOG = 700;
	private static final int DELAY = 100;
	private static final int DELAY_GOG = 2;
	private static final int RANGE = 5;
	private static final int RANGE_Y = 3;

	public SubTileOrechid(class_2591<?> type) {
		super(type);
	}

	public SubTileOrechid() {
		this(ModSubtiles.ORECHID);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236 || redstoneSignal > 0 || !canOperate()) {
			return;
		}

		int cost = getCost();
		if (getMana() >= cost && ticksExisted % getDelay() == 0) {
			class_2338 coords = getCoordsToPut();
			if (coords != null) {
				class_2680 state = getOreToPut();
				if (state != null) {
					method_10997().method_8501(coords, state);
					if (ConfigHandler.COMMON.blockBreakParticles.getValue()) {
						method_10997().method_20290(2001, coords, class_2248.method_9507(state));
					}
					method_10997().method_8396(null, coords, ModSounds.orechid, class_3419.field_15245, 2F, 1F);

					addMana(-cost);
					sync();
				}
			}
		}
	}

	@Nullable
	private class_2680 getOreToPut() {
		Map<class_2960, Integer> map = getOreMap();
		List<TagRandomItem> values = map.entrySet().stream()
				.flatMap(e -> {
					class_3494<class_2248> tag = class_3481.method_15073().method_30210(e.getKey());
					if (tag != null && !tag.method_15138().isEmpty()) {
						return Stream.of(new TagRandomItem(e.getValue(), tag));
					} else {
						return Stream.empty();
					}
				})
				.collect(Collectors.toList());

		if (class_3549.method_15445(values) == 0) {
			return null;
		}

		class_3494<class_2248> ore = class_3549.method_15446(method_10997().field_9229, values).tag;
		return selectFromTag(ore).method_9564();
	}

	private class_2248 selectFromTag(class_3494<class_2248> ore) {
		List<? extends String> mods = ConfigHandler.COMMON.orechidPriorityMods.getValue();
		for (String modid : mods) {
			for (class_2248 block : ore.method_15138()) {
				if (modid.equals(class_2378.field_11146.method_10221(block).method_12836())) {
					return block;
				}
			}
		}
		return ore.method_15142(method_10997().method_8409());
	}

	private class_2338 getCoordsToPut() {
		List<class_2338> possibleCoords = new ArrayList<>();

		for (class_2338 pos : class_2338.method_10097(getEffectivePos().method_10069(-RANGE, -RANGE_Y, -RANGE),
				getEffectivePos().method_10069(RANGE, RANGE_Y, RANGE))) {
			class_2680 state = method_10997().method_8320(pos);
			if (getReplaceMatcher().test(state)) {
				possibleCoords.add(pos.method_10062());
			}
		}

		if (possibleCoords.isEmpty()) {
			return null;
		}
		return possibleCoords.get(method_10997().field_9229.nextInt(possibleCoords.size()));
	}

	public boolean canOperate() {
		return true;
	}

	public Map<class_2960, Integer> getOreMap() {
		return BotaniaAPI.instance().getOreWeights();
	}

	public Predicate<class_2680> getReplaceMatcher() {
		return state -> state.method_26204() == class_2246.field_10340;
	}

	public int getCost() {
		return Botania.gardenOfGlassLoaded ? COST_GOG : COST;
	}

	public int getDelay() {
		return Botania.gardenOfGlassLoaded ? DELAY_GOG : DELAY;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), RANGE);
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	@Override
	public int getColor() {
		return 0x818181;
	}

	@Override
	public int getMaxMana() {
		return getCost();
	}

	private static class TagRandomItem extends class_3549.class_3550 {

		public final class_3494<class_2248> tag;

		public TagRandomItem(int weight, class_3494<class_2248> tag) {
			super(weight);
			this.tag = tag;
		}

	}
}
