/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ConfigHandler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3549;

public class SubTileMarimorphosis extends TileEntityFunctionalFlower {
	private static final int COST = 12;
	private static final int RANGE = 8;
	private static final int RANGE_Y = 5;

	private static final int RANGE_MINI = 2;
	private static final int RANGE_Y_MINI = 1;

	// TODO should this try to match the exact same biome sets as <=1.16.1? is this close enough?
	private enum Type {
		FOREST(ModFluffBlocks.biomeStoneForest, class_1959.class_1961.field_9370),
		PLAINS(ModFluffBlocks.biomeStonePlains, class_1959.class_1961.field_9355),
		MOUNTAIN(ModFluffBlocks.biomeStoneMountain, class_1959.class_1961.field_9357),
		MUSHROOM(ModFluffBlocks.biomeStoneFungal, class_1959.class_1961.field_9365),
		SWAMP(ModFluffBlocks.biomeStoneSwamp, class_1959.class_1961.field_9364),
		SANDY(ModFluffBlocks.biomeStoneDesert, class_1959.class_1961.field_9368, class_1959.class_1961.field_9363),
		COLD(ModFluffBlocks.biomeStoneTaiga, class_1959.class_1961.field_9362, class_1959.class_1961.field_9361),
		MESA(ModFluffBlocks.biomeStoneMesa, class_1959.class_1961.field_9354);

		private final class_2248 biomeStone;
		private final class_1959.class_1961[] categories;

		Type(class_2248 biomeStone, class_1959.class_1961... categories) {
			this.biomeStone = biomeStone;
			this.categories = categories;
		}

		public boolean contains(class_1959.class_1961 category) {
			for (class_1959.class_1961 c : categories) {
				if (c == category) {
					return true;
				}
			}
			return false;
		}
	}

	public SubTileMarimorphosis(class_2591<?> type) {
		super(type);
	}

	public SubTileMarimorphosis() {
		this(ModSubtiles.MARIMORPHOSIS);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();
		if (method_10997().field_9236 || redstoneSignal > 0) {
			return;
		}

		if (getMana() >= COST && ticksExisted % 2 == 0) {
			class_2338 coords = getCoordsToPut();
			if (coords != null) {
				class_2680 state = getStoneToPut(coords);
				if (state != null) {
					method_10997().method_8501(coords, state);
					if (ConfigHandler.COMMON.blockBreakParticles.getValue()) {
						method_10997().method_20290(2001, coords, class_2248.method_9507(state));
					}

					addMana(-COST);
					sync();
				}
			}
		}
	}

	public class_2680 getStoneToPut(class_2338 coords) {
		class_1959.class_1961 category = method_10997().method_23753(coords).method_8688();

		List<StoneEntry> values = new ArrayList<>();
		for (Type type : Type.values()) {
			values.add(new StoneEntry(type, type.contains(category) ? 12 : 1));
		}
		return class_3549.method_15446(method_10997().field_9229, values).type.biomeStone.method_9564();
	}

	private static class StoneEntry extends class_3549.class_3550 {
		private final Type type;

		public StoneEntry(Type type, int weight) {
			super(weight);
			this.type = type;
		}
	}

	private class_2338 getCoordsToPut() {
		List<class_2338> possibleCoords = new ArrayList<>();

		int range = getRange();
		int rangeY = getRangeY();

		for (class_2338 pos : class_2338.method_10097(getEffectivePos().method_10069(-range, -rangeY, -range),
				getEffectivePos().method_10069(range, rangeY, range))) {
			class_2680 state = method_10997().method_8320(pos);
			if (state.method_26204() == class_2246.field_10340) {
				possibleCoords.add(pos.method_10062());
			}
		}

		if (possibleCoords.isEmpty()) {
			return null;
		}
		return possibleCoords.get(method_10997().field_9229.nextInt(possibleCoords.size()));
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), getRange());
	}

	public int getRange() {
		return RANGE;
	}

	public int getRangeY() {
		return RANGE_Y;
	}

	@Override
	public int getColor() {
		return 0x769897;
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	@Override
	public int getMaxMana() {
		return 1000;
	}

	public static class Mini extends SubTileMarimorphosis {
		public Mini() {
			super(ModSubtiles.MARIMORPHOSIS_CHIBI);
		}

		@Override
		public int getRange() {
			return RANGE_MINI;
		}

		@Override
		public int getRangeY() {
			return RANGE_Y_MINI;
		}
	}

}
