/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.components.EntityComponents;
import vazkii.botania.common.lib.ModTags;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1322;
import net.minecraft.class_1548;
import net.minecraft.class_1549;
import net.minecraft.class_1551;
import net.minecraft.class_1560;
import net.minecraft.class_1576;
import net.minecraft.class_1588;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1628;
import net.minecraft.class_1642;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_47;
import net.minecraft.class_5134;
import net.minecraft.class_5425;

public class SubTileLoonuim extends TileEntityFunctionalFlower {
	private static final int COST = 35000;
	private static final int RANGE = 5;
	private static final String TAG_LOOT_TABLE = "lootTable";
	private static final String TAG_ITEMSTACK_TO_DROP = "botania:looniumItemStackToDrop";

	private class_2960 lootTable = new class_2960("minecraft", "chests/simple_dungeon");

	public SubTileLoonuim() {
		super(ModSubtiles.LOONIUM);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		class_1937 world = method_10997();
		if (!world.field_9236 && redstoneSignal == 0 && ticksExisted % 100 == 0
				&& getMana() >= COST && world.method_8407() != class_1267.field_5801) {
			Random rand = world.field_9229;

			class_1799 stack;
			do {
				class_47 ctx = new class_47.class_48((class_3218) world).method_309(class_173.field_1175);
				List<class_1799> stacks = ((class_3218) world).method_8503().method_3857()
						.method_367(lootTable).method_319(ctx);
				if (stacks.isEmpty()) {
					return;
				} else {
					Collections.shuffle(stacks);
					stack = stacks.get(0);
				}
			} while (stack.method_7960() || ModTags.Items.LOONIUM_BLACKLIST.method_15141(stack.method_7909()));

			int bound = RANGE * 2 + 1;
			int xp = getEffectivePos().method_10263() - RANGE + rand.nextInt(bound);
			int yp = getEffectivePos().method_10264();
			int zp = getEffectivePos().method_10260() - RANGE + rand.nextInt(bound);

			class_2338 pos = new class_2338(xp, yp - 1, zp);
			do {
				pos = pos.method_10084();
				if (pos.method_10264() >= 254) {
					return;
				}
			} while (world.method_8320(pos).method_26228(world, pos));
			pos = pos.method_10084();

			double x = pos.method_10263() + Math.random();
			double y = pos.method_10264() + Math.random();
			double z = pos.method_10260() + Math.random();

			class_1588 entity = null;
			if (world.field_9229.nextInt(50) == 0) {
				entity = new class_1560(class_1299.field_6091, world);
			} else if (world.field_9229.nextInt(10) == 0) {
				entity = new class_1548(class_1299.field_6046, world);
				if (world.field_9229.nextInt(200) == 0) {
					entity.method_5800((class_3218) world, null);
				}
			} else {
				switch (world.field_9229.nextInt(3)) {
				case 0:
					if (world.field_9229.nextInt(10) == 0) {
						entity = new class_1576(class_1299.field_6071, world);
					} else if (world.field_9229.nextInt(5) == 0) {
						entity = new class_1551(class_1299.field_6123, world);
					} else {
						entity = new class_1642(world);
					}
					break;
				case 1:
					if (world.field_9229.nextInt(10) == 0) {
						entity = new class_1627(class_1299.field_6098, world);
					} else {
						entity = new class_1613(class_1299.field_6137, world);
					}
					break;
				case 2:
					if (world.field_9229.nextInt(10) == 0) {
						entity = new class_1549(class_1299.field_6084, world);
					} else {
						entity = new class_1628(class_1299.field_6079, world);
					}
					break;
				}
			}

			entity.method_5641(x, y, z, world.field_9229.nextFloat() * 360F, 0);
			entity.method_18799(class_243.field_1353);

			entity.method_5996(class_5134.field_23716).method_26837(new class_1322("Loonium Modififer Health", 2, class_1322.class_1323.field_6330));
			entity.method_5996(class_5134.field_23721).method_26837(new class_1322("Loonium Modififer Damage", 1.5, class_1322.class_1323.field_6330));

			entity.method_6092(new class_1293(class_1294.field_5918,
					entity instanceof class_1548 ? 100 : Integer.MAX_VALUE, 0));
			entity.method_6092(new class_1293(class_1294.field_5924,
					entity instanceof class_1548 ? 100 : Integer.MAX_VALUE, 0));

			EntityComponents.LOONIUM_DROP.get(entity).setDrop(stack);

			entity.method_5943((class_5425) world, world.method_8404(pos), class_3730.field_16469, null, null);
			world.method_8649(entity);
			entity.method_5990();

			addMana(-COST);
			sync();
		}
	}

	@Override
	public int getColor() {
		return 0x274A00;
	}

	@Override
	public int getMaxMana() {
		return COST;
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), RANGE);
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);
		if (cmp.method_10545(TAG_LOOT_TABLE)) {
			lootTable = new class_2960(cmp.method_10558(TAG_LOOT_TABLE));
		}
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);
		cmp.method_10582(TAG_LOOT_TABLE, lootTable.toString());
	}
}
