/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ConfigHandler;

public class SubTileJadedAmaranthus extends TileEntityFunctionalFlower {
	private static final int COST = 100;
	final int RANGE = 4;

	public SubTileJadedAmaranthus() {
		super(ModSubtiles.JADED_AMARANTHUS);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236 || redstoneSignal > 0) {
			return;
		}

		if (ticksExisted % 30 == 0 && getMana() >= COST) {
			class_2338 pos = new class_2338(
					getEffectivePos().method_10263() - RANGE + method_10997().field_9229.nextInt(RANGE * 2 + 1),
					getEffectivePos().method_10264() + RANGE,
					getEffectivePos().method_10260() - RANGE + method_10997().field_9229.nextInt(RANGE * 2 + 1)
			);

			class_2338 up = pos.method_10084();

			for (int i = 0; i < RANGE * 2; i++) {
				class_1767 color = class_1767.method_7791(method_10997().field_9229.nextInt(16));
				class_2680 flower = ModBlocks.getFlower(color).method_9564();

				if (method_10997().method_22347(up) && flower.method_26184(method_10997(), up)) {
					if (ConfigHandler.COMMON.blockBreakParticles.getValue()) {
						method_10997().method_20290(2001, up, class_2248.method_9507(flower));
					}
					method_10997().method_8501(up, flower);
					addMana(-COST);
					sync();

					break;
				}

				up = pos;
				pos = pos.method_10074();
			}
		}
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	@Override
	public int getColor() {
		return 0x961283;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), RANGE);
	}

	@Override
	public int getMaxMana() {
		return COST;
	}

}
