/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;

import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_238;

public class SubTileHyacidus extends TileEntityFunctionalFlower {
	private static final int RANGE = 6;
	private static final int COST = 20;

	public SubTileHyacidus() {
		super(ModSubtiles.HYACIDUS);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236 || redstoneSignal > 0) {
			return;
		}

		List<class_1309> entities = method_10997().method_18467(class_1309.class, new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1)));
		for (class_1309 entity : entities) {
			if (!(entity instanceof class_1657) && entity.method_6112(class_1294.field_5899) == null && getMana() >= COST && !entity.field_6002.field_9236 && entity.method_6046() != class_1310.field_6289) {
				entity.method_6092(new class_1293(class_1294.field_5899, 60, 0));
				addMana(-COST);
			}
		}
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	@Override
	public int getColor() {
		return 0x8B438F;
	}

	@Override
	public int getMaxMana() {
		return 180;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), RANGE);
	}

}
