/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import com.mojang.blaze3d.systems.RenderSystem;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.mixin.AccessorItemEntity;

import java.util.ArrayList;
import java.util.List;

public class SubTileHopperhock extends TileEntityFunctionalFlower {
	private static final String TAG_FILTER_TYPE = "filterType";
	private static final int RANGE_MANA = 10;
	private static final int RANGE = 6;

	private static final int RANGE_MANA_MINI = 2;
	private static final int RANGE_MINI = 1;

	private int filterType = 0;

	public SubTileHopperhock(class_2591<?> type) {
		super(type);
	}

	public SubTileHopperhock() {
		this(ModSubtiles.HOPPERHOCK);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236 || redstoneSignal > 0) {
			return;
		}

		boolean pulledAny = false;
		int range = getRange();

		class_2338 pos = getEffectivePos();

		List<class_1542> items = method_10997().method_18467(class_1542.class, new class_238(pos.method_10069(-range, -range, -range), pos.method_10069(range + 1, range + 1, range + 1)));
		int slowdown = getSlowdownFactor();

		for (class_1542 item : items) {
			int age = ((AccessorItemEntity) item).getAge();
			if (age < 60 + slowdown || age >= 105 && age < 110 || !item.method_5805() || item.method_6983().method_7960()) {
				continue;
			}

			class_1799 stack = item.method_6983();
			class_1263 invToPutItemIn = null;
			boolean priorityInv = false;
			int amountToPutIn = 0;
			class_2350 direction = null;

			for (class_2350 dir : class_2350.values()) {
				class_2338 pos_ = pos.method_10093(dir);

				class_1263 inv = InventoryHelper.getInventory(method_10997(), pos_, dir.method_10153());
				if (inv != null) {
					List<class_1799> filter = getFilterForInventory(pos_, true);
					boolean canAccept = canAcceptItem(stack, filter, filterType);

					class_1799 simulate = InventoryHelper.simulateTransfer(inv, stack, dir.method_10153());
					int availablePut = stack.method_7947() - simulate.method_7947();

					canAccept &= availablePut > 0;

					if (canAccept) {
						boolean priority = !filter.isEmpty();

						setInv: {
							if (priorityInv && !priority) {
								break setInv;
							}

							invToPutItemIn = inv;
							priorityInv = priority;
							amountToPutIn = availablePut;
							direction = dir;
						}
					}
				}
			}

			if (invToPutItemIn != null && item.method_5805()) {
				SubTileSpectranthemum.spawnExplosionParticles(item, 3);
				class_2614.method_11260(null, invToPutItemIn, stack.method_7971(amountToPutIn), direction);
				item.method_6979(stack); // Just in case someone subclasses EntityItem and changes something important.
				pulledAny = true;
			}
		}

		if (pulledAny && getMana() > 0) {
			addMana(-1);
		}
	}

	public boolean canAcceptItem(class_1799 stack, List<class_1799> filter, int filterType) {
		if (stack.method_7960()) {
			return false;
		}

		if (filter.isEmpty()) {
			return true;
		}

		switch (filterType) {
		case 0: { // Accept items in frames only
			boolean anyFilter = false;
			for (class_1799 filterEntry : filter) {
				if (filterEntry == null || filterEntry.method_7960()) {
					continue;
				}
				anyFilter = true;

				if (matches(stack, filterEntry)) {
					return true;
				}
			}

			return !anyFilter;
		}
		case 1:
			return !canAcceptItem(stack, filter, 0); // Accept items not in frames only
		default:
			return true; // Accept all items
		}
	}

	public static boolean matches(class_1799 stack, class_1799 filter) {
		class_1792 item = stack.method_7909();
		if (item != filter.method_7909()) {
			return false;
		}

		if (item instanceof IManaItem) {
			IManaItem manaItem = (IManaItem) item;
			return getFullness(manaItem, stack) == getFullness(manaItem, filter);
		} else {
			return class_1799.method_7975(filter, stack);
		}
	}

	/**
	 * Returns the fullness of the mana item:
	 * 0 if empty, 1 if partially full, 2 if full.
	 */
	public static int getFullness(IManaItem item, class_1799 stack) {
		int mana = item.getMana(stack);
		int fuzz = 10;
		return mana <= fuzz ? 0 : (mana + fuzz < item.getMaxMana(stack) ? 1 : 2);
	}

	public List<class_1799> getFilterForInventory(class_2338 pos, boolean recursiveForDoubleChests) {
		List<class_1799> filter = new ArrayList<>();

		if (recursiveForDoubleChests) {
			class_2680 chest = method_10997().method_8320(pos);

			if (chest.method_28498(class_2281.field_10770)) {
				class_2745 type = chest.method_11654(class_2281.field_10770);
				if (type != class_2745.field_12569) {
					class_2338 other = pos.method_10093(class_2281.method_9758(chest));
					if (method_10997().method_8320(other).method_26204() == chest.method_26204()) {
						filter.addAll(getFilterForInventory(other, false));
					}
				}
			}
		}

		for (class_2350 dir : class_2350.values()) {
			class_238 aabb = new class_238(pos.method_10093(dir));
			List<class_1533> frames = method_10997().method_18467(class_1533.class, aabb);
			for (class_1533 frame : frames) {
				if (frame.method_5735() == dir) {
					filter.add(frame.method_6940());
				}
			}
		}

		return filter;
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	@Override
	public boolean onWanded(class_1657 player, class_1799 wand) {
		if (player == null || player.method_5715()) {
			filterType = filterType == 2 ? 0 : filterType + 1;
			sync();

			return true;
		} else {
			return super.onWanded(player, wand);
		}
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), getRange());
	}

	public int getRange() {
		return getMana() > 0 ? RANGE_MANA : RANGE;
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);

		cmp.method_10569(TAG_FILTER_TYPE, filterType);
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);

		filterType = cmp.method_10550(TAG_FILTER_TYPE);
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void renderHUD(class_4587 ms, class_310 mc) {
		super.renderHUD(ms, mc);

		String filter = class_1074.method_4662("botaniamisc.filter" + filterType);
		int x = mc.method_22683().method_4486() / 2 - mc.field_1772.method_1727(filter) / 2;
		int y = mc.method_22683().method_4502() / 2 + 30;

		mc.field_1772.method_1720(ms, filter, x, y, class_124.field_1080.method_532());
		RenderSystem.disableLighting();
	}

	@Override
	public int getMaxMana() {
		return 20;
	}

	@Override
	public int getColor() {
		return 0x3F3F3F;
	}

	public static class Mini extends SubTileHopperhock {
		public Mini() {
			super(ModSubtiles.HOPPERHOCK_CHIBI);
		}

		@Override
		public int getRange() {
			return getMana() > 0 ? RANGE_MANA_MINI : RANGE_MINI;
		}
	}
}
