/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.base.Predicates;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.mixin.AccessorGoalSelector;
import vazkii.botania.mixin.AccessorMobEntity;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1355;
import net.minecraft.class_1399;
import net.minecraft.class_1569;
import net.minecraft.class_238;
import net.minecraft.class_4135;

public class SubTileHeiseiDream extends TileEntityFunctionalFlower {
	private static final int RANGE = 5;
	private static final int COST = 100;

	public SubTileHeiseiDream() {
		super(ModSubtiles.HEISEI_DREAM);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236) {
			return;
		}

		@SuppressWarnings("unchecked")
		List<class_1569> mobs = (List) method_10997().method_8390(class_1297.class, new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1)), Predicates.instanceOf(class_1569.class));

		if (mobs.size() > 1 && getMana() >= COST) {
			for (class_1569 mob : mobs) {
				if (mob instanceof class_1308) {
					class_1308 entity = (class_1308) mob;
					if (brainwashEntity(entity, mobs)) {
						addMana(-COST);
						sync();
						break;
					}
				}
			}
		}
	}

	public static boolean brainwashEntity(class_1308 entity, List<class_1569> mobs) {
		class_1309 target = entity.method_5968();
		boolean did = false;

		if (!(target instanceof class_1569)) {
			class_1569 newTarget;
			do {
				newTarget = mobs.get(entity.field_6002.field_9229.nextInt(mobs.size()));
			} while (newTarget == entity);

			if (newTarget instanceof class_1308) {
				entity.method_5980(null);

				// Move any EntityAIHurtByTarget to highest priority
				class_1355 targetSelector = ((AccessorMobEntity) entity).getTargetSelector();
				for (class_4135 entry : ((AccessorGoalSelector) targetSelector).getGoals()) {
					if (entry.method_19058() instanceof class_1399) {
						// Concurrent modification OK since we break out of the loop
						targetSelector.method_6280(entry.method_19058());
						targetSelector.method_6277(-1, entry.method_19058());
						break;
					}
				}

				// Now set revenge target, which EntityAIHurtByTarget will pick up
				entity.method_6015((class_1308) newTarget);
				did = true;
			}
		}

		return did;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), RANGE);
	}

	@Override
	public int getColor() {
		return 0xFF219D;
	}

	@Override
	public int getMaxMana() {
		return 1000;
	}

}
