/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;

import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;

public class SubTileFallenKanade extends TileEntityFunctionalFlower {
	private static final int RANGE = 2;
	private static final int COST = 120;

	public SubTileFallenKanade() {
		super(ModSubtiles.FALLEN_KANADE);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (!method_10997().field_9236 && method_10997().method_27983() != class_1937.field_25181) {
			boolean did = false;
			List<class_1657> players = method_10997().method_18467(class_1657.class, new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1)));
			for (class_1657 player : players) {
				if (player.method_6112(class_1294.field_5924) == null && getMana() >= COST) {
					player.method_6092(new class_1293(class_1294.field_5924, 59, 2, true, true));
					addMana(-COST);
					did = true;
				}
			}
			if (did) {
				sync();
			}
		}
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), RANGE);
	}

	@Override
	public int getColor() {
		return 0xFFFF00;
	}

	@Override
	public int getMaxMana() {
		return 900;
	}

}
