/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.network.PacketItemAge;
import vazkii.botania.mixin.AccessorItemEntity;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class SubTileDaffomill extends TileEntityFunctionalFlower {
	private static final String TAG_ORIENTATION = "orientation";
	private static final String TAG_WIND_TICKS = "windTicks";

	private int windTicks = 0;
	private class_2350 orientation = class_2350.field_11043;

	public SubTileDaffomill() {
		super(ModSubtiles.DAFFOMILL);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9229.nextInt(4) == 0) {
			WispParticleData data = WispParticleData.wisp(0.25F + (float) Math.random() * 0.15F, 0.05F, 0.05F, 0.05F);
			field_11863.method_8406(data, getEffectivePos().method_10263() + Math.random(), getEffectivePos().method_10264() + Math.random(), getEffectivePos().method_10260() + Math.random(), orientation.method_10148() * 0.1F, orientation.method_10164() * 0.1F, orientation.method_10165() * 0.1F);
		}

		if (windTicks == 0 && getMana() > 0) {
			windTicks = 20;
			addMana(-1);
		}

		if (windTicks > 0 && redstoneSignal == 0) {
			class_238 axis = aabbForOrientation();

			if (axis != null) {
				List<class_1542> items = method_10997().method_18467(class_1542.class, axis);
				int slowdown = getSlowdownFactor();
				for (class_1542 item : items) {
					if (item.method_5805() && ((AccessorItemEntity) item).getAge() >= slowdown) {
						item.method_18800(
								item.method_18798().method_10216() + orientation.method_10148() * 0.05,
								item.method_18798().method_10214() + orientation.method_10164() * 0.05,
								item.method_18798().method_10215() + orientation.method_10165() * 0.05
						);
					}
				}
			}

			windTicks--;
		}
	}

	private class_238 aabbForOrientation() {
		int x = getEffectivePos().method_10263();
		int y = getEffectivePos().method_10264();
		int z = getEffectivePos().method_10260();
		int w = 2;
		int h = 3;
		int l = 16;

		class_238 axis = null;
		switch (orientation) {
		case field_11043:
			axis = new class_238(x - w, y - h, z - l, x + w + 1, y + h, z);
			break;
		case field_11035:
			axis = new class_238(x - w, y - h, z + 1, x + w + 1, y + h, z + l + 1);
			break;
		case field_11039:
			axis = new class_238(x - l, y - h, z - w, x, y + h, z + w + 1);
			break;
		case field_11034:
			axis = new class_238(x + 1, y - h, z - w, x + l + 1, y + h, z + w + 1);
			break;
		default:
		}
		return axis;
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	@Override
	public boolean onWanded(class_1657 player, class_1799 wand) {
		if (player == null) {
			return false;
		}

		if (player.method_5715()) {
			if (!player.field_6002.field_9236) {
				orientation = orientation.method_10170();
				sync();
			}

			return true;
		} else {
			return super.onWanded(player, wand);
		}
	}

	@Override
	public void onBlockPlacedBy(class_1937 world, class_2338 pos, class_2680 state, class_1309 entity, class_1799 stack) {
		if (entity != null) {
			orientation = entity.method_5735();
		}
		super.onBlockPlacedBy(world, pos, state, entity, stack);
	}

	@Override
	public RadiusDescriptor getRadius() {
		class_238 aabb = aabbForOrientation();
		aabb = new class_238(aabb.field_1323, getEffectivePos().method_10264(), aabb.field_1321, aabb.field_1320, aabb.field_1325, aabb.field_1324);
		return new RadiusDescriptor.Rectangle(getEffectivePos(), aabb);
	}

	@Override
	public int getColor() {
		return 0xD8BA00;
	}

	@Override
	public int getMaxMana() {
		return 100;
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);

		cmp.method_10569(TAG_ORIENTATION, orientation.method_10146());
		cmp.method_10569(TAG_WIND_TICKS, windTicks);
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);

		orientation = class_2350.method_10143(cmp.method_10550(TAG_ORIENTATION));
		windTicks = cmp.method_10550(TAG_WIND_TICKS);
	}

	// Send item age to client to prevent client desync when an item is e.g. dropped by a powered open crate
	public static void onItemTrack(class_3222 player, class_1297 entity) {
		if (entity instanceof class_1542) {
			int entityId = entity.method_5628();
			int age = ((AccessorItemEntity) entity).getAge();
			PacketItemAge.send(player, entityId, age);
		}
	}
}
