/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_2350;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.tile.mana.TilePool;

import javax.annotation.Nullable;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public class SubTileBergamute extends TileEntitySpecialFlower {
	private static final int RANGE = 4;
	private static final Set<SubTileBergamute> existingFlowers = Collections.newSetFromMap(new WeakHashMap<>());
	private static final Set<class_1113> mutedSounds = Collections.newSetFromMap(new WeakHashMap<>());
	private boolean disabled = false;

	public SubTileBergamute() {
		super(ModSubtiles.BERGAMUTE);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236) {
			disabled = false;
			for (class_2350 dir : class_2350.values()) {
				int redstoneSide = method_10997().method_8499(method_11016().method_10093(dir), dir);
				if (redstoneSide > 0) {
					disabled = true;
					break;
				}
			}
			existingFlowers.add(this);
		}
	}

	@Override
	public void method_11012() {
		super.method_11012();
		existingFlowers.remove(this);
	}

	// todo seems expensive when we have lots of sounds cache maybe?
	@Nullable
	private static SubTileBergamute getBergamuteNearby(double x, double y, double z) {
		for (SubTileBergamute f : existingFlowers) {
			if (!f.disabled && f.getEffectivePos().method_10268(x, y, z, true) <= RANGE * RANGE) {
				return f;
			}
		}
		return null;
	}

	@Environment(EnvType.CLIENT)
	public static boolean muteSound(class_1113 sound) {
		SubTileBergamute berg = getBergamuteNearby(sound.method_4784(), sound.method_4779(), sound.method_4778());
		if (berg != null) {
			if (mutedSounds.add(sound) && Math.random() < 0.5) {
				int color = TilePool.PARTICLE_COLOR;
				float red = (color >> 16 & 0xFF) / 255F;
				float green = (color >> 8 & 0xFF) / 255F;
				float blue = (color & 0xFF) / 255F;
				SparkleParticleData data = SparkleParticleData.sparkle((float) Math.random(), red, green, blue, 5);
				berg.method_10997().method_8406(data, berg.getEffectivePos().method_10263() + 0.3 + Math.random() * 0.5, berg.getEffectivePos().method_10264() + 0.5 + Math.random() * 0.5, berg.getEffectivePos().method_10260() + 0.3 + Math.random() * 0.5, 0, 0, 0);
			}
		}
		return berg != null;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Circle(getEffectivePos(), RANGE);
	}

}
