/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1640;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_2591;

public class SubTileBellethorn extends TileEntityFunctionalFlower {
	public static final int RANGE = 6;
	public static final int RANGE_MINI = 1;

	public SubTileBellethorn(class_2591<?> type) {
		super(type);
	}

	public SubTileBellethorn() {
		this(ModSubtiles.BELLETHORNE);
	}

	@Override
	public int getColor() {
		return 0xBA3421;
	}

	@Override
	public int getMaxMana() {
		return 1000;
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236 || redstoneSignal > 0) {
			return;
		}

		if (ticksExisted % 200 == 0) {
			sync();
		}

		final int manaToUse = getManaCost();

		if (ticksExisted % 5 == 0) {
			int range = getRange();
			List<class_1309> entities = method_10997().method_8390(class_1309.class, new class_238(getEffectivePos().method_10069(-range, -range, -range), getEffectivePos().method_10069(range + 1, range + 1, range + 1)), getSelector());

			for (class_1309 entity : entities) {
				if (entity.field_6235 == 0 && getMana() >= manaToUse) {
					int dmg = 4;
					if (entity instanceof class_1640) {
						dmg = 20;
					}

					entity.method_5643(class_1282.field_5846, dmg);
					addMana(-manaToUse);
					break;
				}
			}
		}
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	public int getManaCost() {
		return 24;
	}

	public int getRange() {
		return RANGE;
	}

	public Predicate<class_1297> getSelector() {
		return entity -> !(entity instanceof class_1657);
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), getRange());
	}

	public static class Mini extends SubTileBellethorn {
		public Mini() {
			super(ModSubtiles.BELLETHORNE_CHIBI);
		}

		@Override
		public int getRange() {
			return RANGE_MINI;
		}
	}

}
