/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.collect.ImmutableSet;

import net.minecraft.block.*;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2473;
import net.minecraft.class_2500;
import net.minecraft.class_2513;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3614;
import net.minecraft.class_3830;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ModSounds;

import java.util.Set;

public class SubTileAgricarnation extends TileEntityFunctionalFlower {
	private static final Set<class_3614> MATERIALS = ImmutableSet.of(class_3614.field_15935, class_3614.field_15925, class_3614.field_15945,
			class_3614.field_15923, class_3614.field_15954, class_3614.field_15947, class_3614.field_15946, class_3614.field_15938);
	private static final int RANGE = 5;
	private static final int RANGE_MINI = 2;

	protected SubTileAgricarnation(class_2591<?> type) {
		super(type);
	}

	public SubTileAgricarnation() {
		this(ModSubtiles.AGRICARNATION);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236) {
			return;
		}

		if (ticksExisted % 200 == 0) {
			sync();
		}

		if (ticksExisted % 6 == 0 && redstoneSignal == 0) {
			int range = getRange();
			int x = getEffectivePos().method_10263() + method_10997().field_9229.nextInt(range * 2 + 1) - range;
			int z = getEffectivePos().method_10260() + method_10997().field_9229.nextInt(range * 2 + 1) - range;

			for (int i = 4; i > -2; i--) {
				int y = getEffectivePos().method_10264() + i;
				class_2338 pos = new class_2338(x, y, z);
				if (method_10997().method_22347(pos)) {
					continue;
				}

				if (isPlant(pos) && getMana() > 5) {
					class_2680 state = method_10997().method_8320(pos);
					addMana(-5);
					state.method_26199((class_3218) field_11863, pos, field_11863.field_9229);
					if (ConfigHandler.COMMON.blockBreakParticles.getValue()) {
						method_10997().method_20290(2005, pos, 6 + method_10997().field_9229.nextInt(4));
					}
					method_10997().method_8465(null, x, y, z, ModSounds.agricarnation, class_3419.field_15245, 0.01F, 0.5F + (float) Math.random() * 0.5F);

					break;
				}
			}
		}
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	/**
	 * @return Whether the block at {@code pos} grows "naturally". That is, whether its IGrowable action is simply
	 *         growing itself, instead of something like spreading around or creating flowers around, etc, and whether
	 *         this
	 *         action would have happened normally over time without bonemeal.
	 */
	private boolean isPlant(class_2338 pos) {
		class_2680 state = method_10997().method_8320(pos);
		class_2248 block = state.method_26204();

		// Spreads when ticked
		if (block instanceof class_2500) {
			return false;
		}

		// Exclude all BushBlock except known vanilla subclasses
		if (block instanceof class_2261 && !(block instanceof class_2302) && !(block instanceof class_2513)
				&& !(block instanceof class_2473) && !(block instanceof class_3830)) {
			return false;
		}

		return MATERIALS.contains(state.method_26207())
				&& block instanceof class_2256
				&& ((class_2256) block).method_9651(method_10997(), pos, state, method_10997().field_9236);
	}

	@Override
	public int getColor() {
		return 0x8EF828;
	}

	@Override
	public int getMaxMana() {
		return 200;
	}

	public int getRange() {
		return RANGE;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), getRange());
	}

	public static class Mini extends SubTileAgricarnation {
		public Mini() {
			super(ModSubtiles.AGRICARNATION_CHIBI);
		}

		@Override
		public int getRange() {
			return RANGE_MINI;
		}
	}

}
