/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile;

import vazkii.botania.api.recipe.IPureDaisyRecipe;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.crafting.ModRecipeTypes;

import javax.annotation.Nullable;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import java.util.Arrays;

public class SubTilePureDaisy extends TileEntitySpecialFlower {
	private static final String TAG_POSITION = "position";
	private static final String TAG_TICKS_REMAINING = "ticksRemaining";
	private static final int RECIPE_COMPLETE_EVENT = 0;

	private static final class_2338[] POSITIONS = {
			new class_2338(-1, 0, -1),
			new class_2338(-1, 0, 0),
			new class_2338(-1, 0, 1),
			new class_2338(0, 0, 1),
			new class_2338(1, 0, 1),
			new class_2338(1, 0, 0),
			new class_2338(1, 0, -1),
			new class_2338(0, 0, -1),
	};

	private int positionAt = 0;
	private final int[] prevTicksRemaining = new int[POSITIONS.length];
	private final int[] ticksRemaining = new int[POSITIONS.length];

	public SubTilePureDaisy() {
		super(ModSubtiles.PURE_DAISY);
		Arrays.fill(prevTicksRemaining, -1);
		Arrays.fill(ticksRemaining, -1);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236) {
			for (int i = 0; i < POSITIONS.length; i++) {
				if (ticksRemaining[i] > 0) {
					class_2338 coords = getEffectivePos().method_10081(POSITIONS[i]);
					SparkleParticleData data = SparkleParticleData.sparkle((float) Math.random(), 1F, 1F, 1F, 5);
					field_11863.method_8406(data, coords.method_10263() + Math.random(), coords.method_10264() + Math.random(), coords.method_10260() + Math.random(), 0, 0, 0);
				}
			}

			return;
		}

		positionAt++;
		if (positionAt == POSITIONS.length) {
			positionAt = 0;
		}

		class_2338 acoords = POSITIONS[positionAt];
		class_2338 coords = getEffectivePos().method_10081(acoords);
		class_1937 world = method_10997();
		if (!world.method_22347(coords)) {
			world.method_16107().method_15396("findRecipe");
			IPureDaisyRecipe recipe = findRecipe(coords);
			world.method_16107().method_15407();

			if (recipe != null) {
				if (ticksRemaining[positionAt] == -1) {
					ticksRemaining[positionAt] = recipe.getTime();
				}

				ticksRemaining[positionAt]--;

				if (ticksRemaining[positionAt] <= 0) {
					ticksRemaining[positionAt] = -1;

					if (recipe.set(world, coords, this)) {
						if (ConfigHandler.COMMON.blockBreakParticles.getValue()) {
							method_10997().method_20290(2001, coords, class_2248.method_9507(recipe.getOutputState()));
						}
						method_10997().method_8427(method_11016(), method_11010().method_26204(), RECIPE_COMPLETE_EVENT, positionAt);
					}
				}

			} else {
				ticksRemaining[positionAt] = -1;
			}
		} else {
			ticksRemaining[positionAt] = -1;
		}

		if (!Arrays.equals(ticksRemaining, prevTicksRemaining)) {
			method_5431();
			sync();
			System.arraycopy(ticksRemaining, 0, prevTicksRemaining, 0, POSITIONS.length);
		}
	}

	@Nullable
	private IPureDaisyRecipe findRecipe(class_2338 coords) {
		class_2680 state = method_10997().method_8320(coords);

		for (class_1860<?> recipe : ModRecipeTypes.getRecipes(field_11863, ModRecipeTypes.PURE_DAISY_TYPE).values()) {
			if (recipe instanceof IPureDaisyRecipe && ((IPureDaisyRecipe) recipe).matches(method_10997(), coords, this, state)) {
				return ((IPureDaisyRecipe) recipe);
			}
		}

		return null;
	}

	@Override
	public boolean method_11004(int type, int param) {
		switch (type) {
		case RECIPE_COMPLETE_EVENT: {
			if (method_10997().field_9236) {
				class_2338 coords = getEffectivePos().method_10081(POSITIONS[param]);
				for (int i = 0; i < 25; i++) {
					double x = coords.method_10263() + Math.random();
					double y = coords.method_10264() + Math.random() + 0.5;
					double z = coords.method_10260() + Math.random();

					WispParticleData data = WispParticleData.wisp((float) Math.random() / 2F, 1, 1, 1);
					method_10997().method_8406(data, x, y, z, 0, 0, 0);
				}
			}

			return true;
		}
		default:
			return super.method_11004(type, param);
		}
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Square(getEffectivePos(), 1);
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		positionAt = cmp.method_10550(TAG_POSITION);

		for (int i = 0; i < ticksRemaining.length; i++) {
			ticksRemaining[i] = cmp.method_10550(TAG_TICKS_REMAINING + i);
		}
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		cmp.method_10569(TAG_POSITION, positionAt);
		for (int i = 0; i < ticksRemaining.length; i++) {
			cmp.method_10569(TAG_TICKS_REMAINING + i, ticksRemaining[i]);
		}
	}

}
