/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.subtile;

import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModSubtiles;

public class SubTileManastar extends TileEntitySpecialFlower {
	private static final int SET_STATE_EVENT = 0;
	private static final int NONE = 0, DECREASING = 1, INCREASING = 2;

	private int lastMana = 0;
	private int state = NONE;

	public SubTileManastar() {
		super(ModSubtiles.MANASTAR);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236) {
			if (state != NONE && Math.random() > 0.6) {
				float r = state == INCREASING ? 0.05F : 1F;
				float b = state == INCREASING ? 1F : 0.05F;
				WispParticleData data = WispParticleData.wisp((float) Math.random() / 7, r, 0.05F, b, 1);
				field_11863.method_8406(data, getEffectivePos().method_10263() + 0.55 + Math.random() * 0.2 - 0.1, getEffectivePos().method_10264() + 0.75 + Math.random() * 0.2 - 0.1, getEffectivePos().method_10260() + 0.5, 0, (float) Math.random() / 50, 0);
			}
		} else {
			int mana = 0;
			for (class_2350 dir : class_2350.class_2353.field_11062) {
				class_2338 pos = getEffectivePos().method_10093(dir);
				if (method_10997().method_22340(pos)) {
					class_2586 tile = method_10997().method_8321(pos);
					if (tile instanceof IManaPool) {
						mana += ((IManaPool) tile).getCurrentMana();
					}
				}
			}

			int newState = mana > lastMana ? INCREASING : mana < lastMana ? DECREASING : NONE;
			if (newState != state) {
				method_10997().method_8427(method_11016(), method_11010().method_26204(), SET_STATE_EVENT, newState);
			}

			if (ticksExisted % 60 == 0) {
				lastMana = mana;
			}
		}
	}

	@Override
	public boolean method_11004(int id, int param) {
		if (id == SET_STATE_EVENT) {
			state = param;
			return true;
		} else {
			return super.method_11004(id, param);
		}
	}

}
