/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.string;

import vazkii.botania.common.block.tile.string.TileRedString;
import vazkii.botania.common.block.tile.string.TileRedStringDispenser;

import javax.annotation.Nonnull;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_4970;

public class BlockRedStringDispenser extends BlockRedString {

	public BlockRedStringDispenser(class_4970.class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12525, class_2350.field_11033).method_11657(class_2741.field_12484, false));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(class_2741.field_12484);
	}

	@Override
	public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
		boolean power = world.method_8482(pos) > 0 || world.method_8482(pos.method_10084()) > 0;
		boolean powered = state.method_11654(class_2741.field_12484);

		if (power && !powered) {
			((TileRedStringDispenser) world.method_8321(pos)).tickDispenser();
			world.method_8652(pos, state.method_11657(class_2741.field_12484, true), 4);
		} else if (!power && powered) {
			world.method_8652(pos, state.method_11657(class_2741.field_12484, false), 4);
		}
	}

	@Nonnull
	@Override
	public TileRedString method_10123(@Nonnull class_1922 world) {
		return new TileRedStringDispenser();
	}
}
